<?php
$cityArray = (issetModule('location')) ? (City::getCitiesArray((isset($this->selectedRegion) ? $this->selectedRegion : 0), 0)) : $this->cityActive;
$cityArray = CArray::merge(array(0 => tc('select city')), $cityArray);
$metros = array();
# для того, чтобы не было пустого select если в выбранном регионе нет объявлений
$onlyWithAds = (issetModule('geo') && (param('geo_in_search') > 0)) ? 0 : 1;

$issetModuleLocation = issetModule('location') ? 1 : 0;

if ($issetModuleLocation) {
    ?>
    <div class="<?php echo $divClass; ?>">
        <div class="block-type <?php echo $formgroup; ?>">

            <div data-toggle="modal" data-target="#location-select">
                <input type="text" value="" placeholder="<?= tc('City') ?>" class="form-control" id="m-sel-city"
                       readonly>
            </div>
        </div>
    </div>

    <div id="location-select" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="myModalLabel"><?= tc('select city') ?></h4>
                </div>
                <div class="modal-body">
                    <?php
                    include '_location.php';
                    include '_one_city.php';
                    ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal"><?= tc('Close') ?></button>
                    <button type="button" class="btn btn-primary" onclick="mSetLocation();"><?= tc('Apply') ?></button>
                </div>
            </div>
        </div>
    </div>

    <?php
    $script = <<< JS

    var issetModuleLocation = $issetModuleLocation;

    function mSetLocation() {
        var locationName = '';
        
       if(issetModuleLocation){
           if($('#city').val() > 0){
              locationName = $('#city option:selected').html();
           } else if($('#region').val() > 0){
               locationName = $('#region option:selected').html();
           } else if($('#country').val() > 0){
               locationName = $('#country option:selected').html();
           }
       } else {
           locationName = $('#ap_city option:selected').html();
       }
       
       $('#m-sel-city').val(locationName);
       
       $('#location-select').modal('hide');
    }
    
    $(function() {
        mSetLocation();
    });
JS;

    Yii::app()->clientScript->registerScript('m-sel-location', $script, CClientScript::POS_END);

} else {
    include '_one_city.php';
}

if (issetModule('metroStations')) {
    include '_metro.php';
}
?>