<?php
$issetModuleMetro = issetModule('metroStations');

$ajax = $onchange = false;

$opacityClass = (!isset($this->selectedCity) || empty($this->selectedCity)) ? ' less-opacity-control' : '';
$options = array(
    'class' => 'width289 searchField' . $opacityClass,
);

if ($issetModuleMetro) {
    $options['onchange'] = '$("#city").removeClass("less-opacity-control");';
    $options['ajax'] = array(
        'type' => 'GET',
        'url' => $this->createUrl('/metroStations/main/getMetroStations'),
        'data' => 'js:"city="+$("#city").val()+"&type=0&onlyWithAds=' . $onlyWithAds . '"',
        'dataType' => 'json',
        'success' => 'function(result){
            if (result.dropdownMetro) { 
                $("#metro-block").show(); 
                $("#metro").removeAttr("disabled");
                $("#metro").html(result.dropdownMetro);
                $("#metro")[0].sumo.reload();
                $("#metro").parent().parent().removeClass("less-opacity-control");
            } 
            else { 
                $("#metro-block").hide(); 
                $("#metro").attr("disabled", "disabled");
                $("#metro").html("");
                $("#metro")[0].sumo.reload();
            }
        }'
    );
}
?>

<div <?php echo ($divClass) ? 'class="' . $divClass . '' : ''; ?>>
    <div class="<?php echo $formgroup; ?>">
        <?php if ($this->searchShowLabel) { ?>
            <div class="<?php echo $textClass; ?>"><?php echo Yii::t('common', 'City') ?>:</div>
        <?php } ?>
        <div class="<?php echo $controlClass; ?>">
            <?php
            echo Select2::dropDownList(
                'city[]', isset($this->selectedCity) ? $this->selectedCity : '', $cityArray, $options
            );
            ?>
        </div>
    </div>
</div>