<div <?php echo ($divClass) ? 'class="' . $divClass . '' : ''; ?>>
    <div class="<?php echo $formgroup; ?>">
        <?php if ($this->searchShowLabel) { ?>
            <div class="<?php echo $textClass; ?>"><?php echo tc('Country') ?>:</div>
        <?php } ?>
        <div class="<?php echo $controlClass; ?>">
            <?php
            echo Select2::dropDownList(
                'country', isset($this->selectedCountry) ? $this->selectedCountry : '', Country::getCountriesArray(2, 0, true), array(
                    'class' => 'searchField',
                    'id' => 'country',
                    'ajax' => array(
                        'type' => 'GET', //request type
                        'url' => $this->createUrl('/location/main/getRegions'), //url to call.
                        'data' => 'js:"country="+$("#country").val()+"&type=2&onlyWithAds=' . $onlyWithAds . '"',
                        'success' => 'function(result){
							$("#region").html(result);
							$("#region").change();
							$("#region").select2().trigger("change");
							$("#region").removeClass("less-opacity-control");
						}'
                    )
                )
            );

            ?>
        </div>
    </div>
</div>

<div <?php echo ($divClass) ? 'class="' . $divClass . '' : ''; ?>>
    <div class="<?php echo $formgroup; ?>">
        <?php if ($this->searchShowLabel) { ?>
            <div class="<?php echo $textClass; ?>"><?php echo tc('Region') ?>:</div>
        <?php } ?>
        <div class="<?php echo $controlClass; ?>">
            <?php $opacityClass = ((!isset($this->selectedRegion) || empty($this->selectedRegion)) && (!isset($this->selectedCountry) || empty($this->selectedCountry))) ? ' less-opacity-control' : ''; ?>
            <?php
            echo Select2::dropDownList(
                'region', isset($this->selectedRegion) ? $this->selectedRegion : '', Region::getRegionsArray((isset($this->selectedCountry) ? $this->selectedCountry : 0), 2), array(
                    'class' => 'searchField' . $opacityClass,
                    'id' => 'region',
                    'onchange' => '$("#region").removeClass("less-opacity-control");',
                    'ajax' => array(
                        'type' => 'GET', //request type
                        'url' => $this->createUrl('/location/main/getCities'), //url to call.
                        'data' => 'js:"region="+$("#region").val()+"&type=2&onlyWithAds=' . $onlyWithAds . '"',
                        'success' => 'function(result){
                            changeSearch();
							$("#city").removeClass("less-opacity-control");
							$("#city").html(result);$("#city").select2().trigger("change");' . ((issetModule('metroStations')) ? '$("#city").change()' : '') .
                            '}'
                    )
                )
            );

            ?>
        </div>
    </div>
</div>