<?php
/**
 * @var LoginCodeForm $model
 */

$this->pageTitle = Yii::app()->name . ' - ' . Yii::t('common', 'Login');
$this->breadcrumbs = array(
    Yii::t('common', 'Login')
);
?>

<div class="content">
    <h1 class="fint h3 l_fint"><?php echo Yii::t('common', 'Login'); ?></h1>

    <p>
        <?php echo Yii::t('common', 'A code has been sent to your E-mail. Please enter it in the field below. The code is valid for {n} minutes.', LoginCodeForm::CODE_ACTIVE_MIN);?>
    </p>

    <div class="well well-sm">
        <div class="form col-md-6">
            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'login-code-form',
                'enableClientValidation' => false,
                'htmlOptions' => array('class' => 'form-disable-button-after-submit'),
                'action' => array('site/logincode'),
                /* 'clientOptions'=>array(
                  'validateOnSubmit'=>true,
                  ), */
            ));
            ?>

            <div class="form-group">
                <?php echo $form->labelEx($model, 'code'); ?>
                <?php echo $form->numberField($model, 'code', array('class' => 'form-control input-login-password-with-eye')); ?>
                <?php echo $form->error($model, 'code'); ?>
            </div>

            <div class="form-group buttons">
                <?php echo CHtml::submitButton(Yii::t('common', 'Login'), array('class' => 'btn btn-primary my-btn submit-button')); ?>
            </div>

            <?php $this->endWidget(); ?>
        </div>
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</div>
