<?php
$baseThemeUrl = Yii::app()->theme->baseUrl;
?>

<div class="city_module">
    <div class="h3 fint text-center">Популярные направления</div>
    <div class="city-slick">

        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-1.jpg" alt="">
            <div class="text">
                <div class="h3">Санкт-Петербург</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>

        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-2.jpg" alt="">
            <div class="text">
                <div class="h3">Краснодар</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-1.jpg" alt="">
            <div class="text">
                <div class="h3">Тюмень</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-1.jpg" alt="">
            <div class="text">
                <div class="h3">Москва</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-1.jpg" alt="">
            <div class="text">
                <div class="h3">Казань</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-1.jpg" alt="">
            <div class="text">
                <div class="h3">Сочи</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
        <div class="item-city">
            <img src="<?= $baseThemeUrl ?>/views/site/demo_images_delete/city/city-bg-2.jpg" alt="">
            <div class="text">
                <div class="h3">Владивосток</div>
                <ul class="list-inline">
                    <li><a href="#">квартиры</a></li>
                    <li><a href="#">дома</a></li>
                    <li><a href="#">участки</a></li>
                    <li><a href="#">дачи</a></li>
                    <li><a href="#">гаражи</a></li>
                </ul>
            </div>
        </div>
    </div>
    <div id="result_city"></div>

    <script>
        //slick carousel for city module
        $('.city-slick').on('init', function (event, slick) {
            $('.item-city.slick-center img').addClass('animation-kenburns scale-kenburns');
        });
        $('.city-slick').slick({
            slidesToShow: 3,
            slidesToScroll: 1,
            autoplay: false,
            variableWidth: true,
            centerMode: true,
            centerPadding: '0',
            responsive: [
                {
                    breakpoint: 1199,
                    settings: {
                        centerPadding: '40px',
                    },
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                        centerPadding: '0px',
                        arrows: false
                    },
                },
            ],
            infinite: true,
            prevArrow: '<button type="button" class="slick-prev slick-arrow slow"><i class="fas fa-chevron-left"></i></button>',
            nextArrow: '<button type="button" class="slick-next slick-arrow slow"><i class="fas fa-chevron-right"></i></button>',
        });

        getActiveCityId();

        $('.city-slick').on('afterChange', function () {
            getActiveCityId();
            $('.item-city.slick-center img').toggleClass('animation-kenburns scale-kenburns');
        })
        $('.city-slick').on('beforeChange', function () {
            $('.item-city.slick-center img').toggleClass('animation-kenburns scale-kenburns');
        })

        function getActiveCityId() {
            $.ajax({
                url: "<?= $baseThemeUrl ?>/views/site/data_for_city_delete.php",
                type: 'POST',
                dataType: 'html',
                data: {cityId: Math.abs($('.item-city.slick-slide.slick-active.slick-center').attr('data-slick-index'))},
                success: function (data1) {
                    $('#result_city').html(data1);
                    $('.city-object-slick').on('init', function (event, slick) {
                        $('.item_obj.animated').addClass('activate fadeIn');
                    });
                    $('.city-object-slick').slick({
                        slidesToShow: 8,
                        slidesToScroll: 1,
                        responsive: [
                            {
                                breakpoint: 1600,
                                settings: {
                                    slidesToShow: 6
                                }
                            },
                            {
                                breakpoint: 1199,
                                settings: {
                                    slidesToShow: 4,
                                }
                            },
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 4
                                }
                            },
                            {
                                breakpoint: 480,
                                settings: {
                                    slidesToShow: 2,
                                    arrows: false,
                                }
                            }
                        ],
                        centerMode: false,
                        infinite: true,
                        arrows: true,
                        prevArrow: '<button type="button" class="slick-prev slick-arrow slow"><i class="fas fa-chevron-left"></i></button>',
                        nextArrow: '<button type="button" class="slick-next slick-arrow slow"><i class="fas fa-chevron-right"></i></button>',
                    });
                }
            });
        }

    </script>
</div>