<div class="block_entries">
    <?php if (!$entries): ?>

        <div class="empty"><?php echo tt('Entries list is empty.', 'entries'); ?></div>
    <?php else: ?>
        <?php if (isset($showWidgetTitle) && $showWidgetTitle): ?>
            <h1><?php echo $customWidgetTitle; ?></h1>
        <?php endif; ?>

        <div class="b_entries ">
            <?php foreach ($entries as $item) : ?>

                <?php $src = false; ?>
                <?php $tagLinks = $item->getTagLinks(); ?>

                <?php if ($item->image): ?>
                    <?php $src = $item->image->getThumb(531, 256); ?>
                <?php endif; ?>
                <div class="item_news">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="img_news">
                                <a href="<?= $item->getUrl() ?>"
                                   style="background-image: url('<?php echo ($src) ? Yii::app()->getBaseUrl() . '/uploads/entries/' . $src : Yii::app()->getBaseUrl() . '/themes/dolphin/assets/images/no_photo_entry.png'; ?>');"></a>
                                <?php if ($tagLinks) { ?>
                                    <ul class="list-inline tags">
                                        <?php foreach ($tagLinks as $link) { ?>
                                            <li><?php echo $link ?></li>
                                        <?php } ?>
                                    </ul>
                                <?php } ?>
                            </div>
                            <?php
                            // $tagAlt = CHtml::encode($item->getStrByLang('title'));
                            // if (issetModule('seo') && isset($item->image->image_seo) && $item->image->image_seo->getStrByLang('alt')) {
                            //     $tagAlt = CHtml::encode($item->image->image_seo->getStrByLang('alt'));
                            // }

                            // ?>

                            <?php
                            // echo CHtml::image(
                            //     Yii::app()->getBaseUrl() . '/uploads/entries/' . $src, $tagAlt
                            // );

                            ?>
                        </div>
                        <div class="b_entries__item_post col-md-9">
                            <div class="title h3">
                                <?php echo CHtml::link(CHtml::encode($item->getStrByLang('title')), $item->getUrl()); ?>
                            </div>
                            <div class="posted"><span class="date"><?php echo $item->dateCreatedLong; ?></span></div>
                            <div class="new_desc">
                                <?php echo $item->getAnnounce(); ?>
                            </div>
                            <?php echo CHtml::link(tt('Read more &raquo;', 'entries'), $item->getUrl(), array('class' => 'btn btn-primary slow read_more')); ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>
<div class="clear"></div>

<?php if ($pages && $pages->pageCount > 1): ?>
    <div class="pagination pagination-bottom">
        <?php
        $this->widget('DolphinPager', array(
            'pages' => $pages,
            'maxButtonCount' => 6,
            'header' => '',
            'selectedPageCssClass' => 'active',
            'nextPageLabel' => '<i class="fas fa-angle-right"></i>',
            'prevPageLabel' => '<i class="fas fa-angle-left"></i>',
            'firstPageLabel' => '<i class="fas fa-angle-double-left"></i>',
            'lastPageLabel' => '<i class="fas fa-angle-double-right"></i>',
            'htmlOptions' => array(
                'class' => 'pagination',
            ),
        ));
        ?>
    </div>
    <div class="clear"></div>
<?php endif; ?>