<?php if ($apartment->type == Apartment::TYPE_RENT) : ?>
    <?php
    Yii::app()->clientScript->registerScript('resize-booking', '
			setTimeout(function(){
				$(".ui-datepicker").width("");
			}, 0);
		', CClientScript::POS_READY);

    ?>
    <div class="calendar-inner">

        <div class="block_heading_full h3"><?php echo tt('Periods of free / reserved apartment', 'bookingcalendar'); ?></div>
        <div class="booking_calendar">
            <?php
            $this->widget('application.modules.bookingcalendar.extensions.Calendar', array(
                'name' => 'bookingCalendarDate' . $apartment->id,
                'options' => array(
                    'numberOfMonths' => 3,
                    'showAnim' => 'fold',
                    'dateFormat' => 'yy-mm-dd',
                    'showCurrentAtPos' => 0,
                    'minDate' => 0,
                ),
                'htmlOptions' => array(
                    'data-apId' => $apartment->id,
                ),
                'flat' => true,
                'language' => Yii::app()->controller->datePickerLang,
                'showDayForId' => $apartment->id,
            ));

            ?>
        </div>
        <div class="calendarDescription">
            <div class="calendarDescriptionReserved"></div>
            <div class="calendarDescriptionText"> - <?php echo tt('Reserved', 'bookingcalendar'); ?></div>
            <div class="calendarDescriptionFree"></div>
            <div class="calendarDescriptionText"> - <?php echo tt('Free', 'bookingcalendar'); ?></div>
        </div>
    </div>


<?php endif; ?>