<?php
/** @var Apartment $item */

$addClass = $lastClass = '';

if (!empty($item->date_up_search) && !is_null($item->date_up_search)) {
    $addClass = 'up_in_search';
}
$url = $item->getUrl();
$title = CHtml::encode($item->getStrByLang('title'));

$addClass .= ' col-md-3 col-sm-6 ';

$lastClass = ' ore-ap-' . $item->id;
?>

<div class="apartment_item block <?php echo $addClass . $lastClass; ?>" data-lat="<?php echo $item->lat; ?>"
     data-lng="<?php echo $item->lng; ?>" data-ap-id="<?php echo $item->id; ?>">

    <div class="item slow">
        <div class="photo_block">

            <?php
            if(issetModule('favorite')){
                $this->widget(\application\modules\favorite\widgets\FavoriteWidget::className(), array(
                    'model' => $item,
                ));
            }

            if ($item->images) {
                $this->widget('application.modules.images.components.ImagesWidgetSlinkyCarousel', array(
                    'images' => $item->images,
                    'objectId' => $item->id,
                    'width' => 330,
                    'height' => 228,
                ));
            } else {
                ?>
                <div class="slinky-gallery">
                    <?php
                    $res = Images::getMainThumb(359, 286, $item->images);
                    $imgAlt = (isset($res['alt']) && $res['alt']) ? $res['alt'] : CHtml::encode($item->getStrByLang('title'));

                    $imgTag = CHtml::image($res['thumbUrl']);
                    echo $imgTag;
                    ?>
                </div>
            <?php }
            //echo '</a>';
            ?>

            <?php if (Yii::app()->user->checkAccess('backend_access') || (param('useUserads') && $item->isOwner())): ?>
                <div class="apartment_item_edit">
                    <a href="<?php echo $item->getEditUrl(); ?>">
                        <i class="fa fa-edit" title="<?php echo tt('Update apartment', 'apartments'); ?>"></i>
                    </a>
                </div>
            <?php endif; ?>


            <div class="bl_wrapper">
                <div class="bl bl_type"><?php echo HApartment::getNameByType($item->type); ?></div>
                <?php if ($item->is_special_offer) { ?>
                    <div class="bl bl_hot"><?php echo tc('Special offer!') ?></div>
                <?php } ?>
            </div>
            <?php if ($item->rating): ?>
                <?php $countComments = (isset($item->countComments) && $item->countComments) ? $item->countComments : 0; ?>
                <ul class="list-unstyled comments_list_bl">
                    <li>
                        <a href="<?php echo $item->getUrl(); ?>#comment_block">
                            <?= Yii::t('common', '{n} review|{n} reviews', $item->getCountComments()); ?>
                        </a>
                    </li>
                    <li>
                        <?php
                        $this->widget('application.modules.comments.components.commentStarWidget', array(
                            'model' => $item,
                            'url' => $item->getUrl(),
                            'showRating' => true,
                        ));
                        ?>
                    </li>
                </ul>
            <?php endif; ?>
        </div>

        <div class="item_content">
            <?php if (param('useShowUserInfo')) { ?>
                <div class="ava">
                    <?php echo $item->user->renderAva(true, '', true, false); ?>
                </div>
            <?php } ?>

            <div class="title_item h4">
                <?php echo '<a href="' . $url . '" class="slow" title="' . $title . '">' . HApartment::getTitleForView($item, 7) . '</a>'; ?>
            </div>
            <hr>
            <div class="adress">
                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                     x="0px" y="0px"
                     width="24.442px" height="25px" viewBox="0 0 24.442 25"
                     enable-background="new 0 0 24.442 25" xml:space="preserve">
                    <title><?= $item->getAttributeLabel('address') ?></title>
                    <g>
                        <line fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" x1="3.291"
                              y1="7.198" x2="11.663"
                              y2="7.198"/>
                        <path fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" d="M0.5,21.722
        c0-1.438,1.116-2.803,2.791-2.803V3.849C1.616,3.849,0.5,5.202,0.5,6.64V21.722z"/>
                        <path fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" d="M21.709,7.198h2.232V24.5H3.303
        c-1.548,0-2.803-1.282-2.803-2.79"/>
                        <polyline fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" points="7.198,23.384 7.198,15.569
        4.407,15.569    "/>
                        <polyline fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" points="4.407,12.779 7.198,12.779
        7.198,8.314     "/>
                        <polyline fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" points="9.988,8.314 9.988,17.803
        22.826,17.803   "/>
                        <polyline fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10" points="9.988,23.384 9.988,20.594
        22.826,20.594   "/>
                        <path fill="none" stroke="#ADADAD" stroke-miterlimit="10" d="M16.686,0.5c2.774,0,5.023,2.195,5.023,4.903
        c0.001,1.171-0.176,1.983-0.858,3.047c-0.682,1.064-4.165,6.003-4.165,6.003s-3.483-4.938-4.165-6.003s-0.86-1.876-0.858-3.047
        C11.663,2.695,13.912,0.5,16.686,0.5z"/>
                        <path fill="none" stroke="#ADADAD" stroke-miterlimit="10" d="M16.684,3.849c0.001,0,0.001,0,0.002,0s0.002,0,0.003,0
        c0.923,0,1.67,0.709,1.672,1.672c0.002,0.963-0.745,1.677-1.667,1.677c-0.003,0-0.005,0-0.008,0c-0.002,0-0.005,0-0.008,0
        c-0.921,0-1.668-0.714-1.666-1.677C15.013,4.558,15.761,3.849,16.684,3.849z"/>
                    </g>
</svg>
                <?php echo HApartment::getLocationString($item); ?>
            </div>

            <?php if ($item->canShowInView('price')) { ?>
                <div class="price">
                    <?php
                    if ($item->is_price_poa) {
                        echo tt('is_price_poa', 'apartments');
                    } else {
                        echo $item->getPrettyPrice(false);
                    }
                    ?>
                    <hr>
                </div>
            <?php } ?>

            <ul class="list-inline spec_info">
                <?php if ($item->num_of_rooms || $item->floor || $item->floor_total || $item->square) { ?>
                    <?php if ($item->canShowInView('num_of_rooms')) { ?>
                        <li>
                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 width="25px" height="19.667px" viewBox="0 0 25 19.667"
                                 enable-background="new 0 0 25 19.667" xml:space="preserve">
<polyline fill="none" stroke="#ADADAD" stroke-miterlimit="10" points="10.278,6.722 10.278,13.833 0.5,13.833 0.5,0.5 10.278,0.5
    10.278,4.056 "/>
                                <title><?= $item->getAttributeLabel('num_of_rooms') ?></title>
                                <polyline fill="none" stroke="#ADADAD" stroke-miterlimit="10"
                                          points="10.278,0.5 24.5,0.5 24.5,9.389 20.944,9.389 "/>
                                <polyline fill="none" stroke="#ADADAD" stroke-miterlimit="10" points="17.389,9.389 20.944,9.389 20.944,19.167 6.722,19.167
    6.722,13.833 "/>
                                <line fill="none" stroke="#ADADAD" stroke-miterlimit="10" x1="14.723" y1="9.389"
                                      x2="10.278" y2="9.389"/>
</svg>
                            <?php echo $item->num_of_rooms; ?>
                        </li>
                    <?php } ?>
                    <?php if (($item->floor) || ($item->floor_total)) { ?>
                        <li>
                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 width="25px" height="25px" viewBox="0 0 25 25"
                                 enable-background="new 0 0 25 25" xml:space="preserve">
                                <?php
                                if (($item->floor) && ($item->floor_total)) {
                                    echo '<title>' . $item->getAttributeLabel('floor') . '/' . $item->getAttributeLabel('floor_total') . '</title>';
                                } elseif ($item->floor) {
                                    echo '<title>' . $item->getAttributeLabel('floor') . '</title>';
                                } elseif ($item->floor_total) {
                                    echo '<title>' . $item->getAttributeLabel('floor_total') . '</title>';
                                }
                                ?>
                                <g>
                                    <polygon fill="none" stroke="#ADADAD" stroke-miterlimit="10" points="18.061,0.5 18.061,6.354 12.208,6.354 12.208,12.208
        6.354,12.208 6.354,18.061 0.5,18.061 0.5,24.5 24.5,24.5 24.5,0.5    "/>
                                </g>
</svg>
                            <?php
                            if (($item->floor) && ($item->floor_total)) {
                                echo $item->floor . '/' . $item->floor_total;
                            } elseif ($item->floor) {
                                echo $item->floor;
                            } elseif ($item->floor_total) {
                                echo $item->floor_total;
                            }
                            ?>
                        </li>
                    <?php } ?>
                    <?php if ($item->canShowInView('square')) { ?>
                        <li>
                            <svg version="1.1" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                 width="25px" height="26.2px" viewBox="0 0 25 26.2"
                                 enable-background="new 0 0 25 26.2" xml:space="preserve">
                                <title><?= $item->getAttributeLabel('square') ?></title>
                                <g>
                                    <polygon fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10"
                                             points="8.3,5.9 8.3,0.5 24.5,0.5
        24.5,20.9 18.5,20.9 18.5,25.7 0.5,25.7 0.5,5.9  "/>
                                    <path fill="none" stroke="#ADADAD" stroke-miterlimit="10" d="M7.1,14.9L7.1,14.9c0-0.99,0.81-1.8,1.8-1.8l0,0
        c0.99,0,1.8,0.81,1.8,1.8l0,0V18.5"/>
                                    <path fill="none" stroke="#ADADAD" stroke-miterlimit="10" d="M10.7,14.9L10.7,14.9c0-0.99,0.81-1.8,1.8-1.8l0,0
        c0.99,0,1.8,0.81,1.8,1.8l0,0V18.5"/>
                                    <line fill="none" stroke="#ADADAD" stroke-miterlimit="10" x1="7.1" y1="18.5"
                                          x2="7.1" y2="12.5"/>
                                    <path fill="none" stroke="#ADADAD" stroke-linejoin="round" stroke-miterlimit="10"
                                          d="M18.5,10.7v1.2h-3v-0.6
        c1.8-1.784,2.431-2.156,2.735-2.766c0.229-0.456,0.415-1.771-0.607-2.127C16.792,6.116,15.746,6.35,15.48,7.49 M15.748,11.262"/>
                                </g>
</svg>
                            <?php echo $item->square . ' ' . tc('site_square'); ?>
                        </li>
                    <?php } ?>

                <?php } ?>
            </ul>

            <?php if (0) { ?>
                <div class="short_desc">
                    <?php
                    if ($item->canShowInView('description')) {
                        $description = $item->getStrByLang('description');
                        echo truncateText($description, 12);
                    }

                    ?>
                </div>
            <?php } ?>
        </div>

        <div class="more_info">
            <?php if (issetModule('comparisonList')) { ?>
                <?php
                $inComparisonList = false;
                if (in_array($item->id, Yii::app()->controller->apInComparison)) {
                    $inComparisonList = true;
                }
                ?>
                <div class="more_bl">
                    <div class="compare">
                        <?php if (issetModule('comparisonList')) { ?>

                            <?php
                            $inComparisonList = false;
                            if (in_array($item->id, Yii::app()->controller->apInComparison)) {
                                $inComparisonList = true;
                            }

                            ?>
                            <div class="compare-check-control"
                                 data-id="<?php echo $item->id; ?>">
                                <div class="pretty p-default">
                                    <?php
                                    $checkedControl = '';

                                    if ($inComparisonList) {
                                        $checkedControl = ' checked = "checked" ';
                                    }
                                    ?>

                                    <div class="state p-warning">
                                        <a href="<?php echo ($inComparisonList) ? Yii::app()->createUrl('comparisonList/main/index') : 'javascript:void(0);'; ?>"
                                           data-rel-compare="<?php echo ($inComparisonList) ? 'true' : 'false'; ?>"
                                           data-id="<?php echo $item->id; ?>"
                                           class="compare-label btn btn-default slow compare-label-<?= $item->id ?>">
                                            <?php
                                            echo ($inComparisonList) ? tt('In the comparison list', 'comparisonList') : tt('Add to a comparison list ', 'comparisonList');
                                            ?>
                                        </a>
                                    </div>

                                    <input type="checkbox" name="compare<?php echo $item->id; ?>"
                                           class="compare-check compare-float-left compare_check_<?php echo $item->id; ?>"
                                           data-id="<?php echo $item->id; ?>"
                                        <?php echo $checkedControl; ?>>
                                </div>
                            </div>
                        <?php } ?>
                    </div>

                </div>
            <?php } ?>
            <div class="more_bl"><a href="<?php echo $url; ?>"
                                    class="btn btn-primary slow"><?php echo tc('View'); ?> <i
                            class="fas fa-angle-double-right"></i></a></div>
            <div class="clear"></div>
        </div>

    </div>
</div>
