<?php
$showSorter = $this->showSorter && $sorter && $count;

$getForMapSwitch = $getForSwitch = HSite::getBaseSwitchUrl($showSorter);
if (isset($getForMapSwitch['is_ajax'])) {
    unset($getForMapSwitch['is_ajax']);
}

$urlsSwitching = array(
    'block' => z_add_url_get(array('ls' => 'block') + $getForSwitch),
    'table' => z_add_url_get(array('ls' => 'table') + $getForSwitch),
    'map' => z_add_url_get(array('ls' => 'map') + $getForMapSwitch),
);

if (!param('useGoogleMap', 0) && !param('useYandexMap', 0) && !param('useOSMMap', 0) || Yii::app()->controller->useAdditionalView == Themes::ADDITIONAL_VIEW_FULL_WIDTH_MAP) {
    unset($urlsSwitching['map']);
}

if (empty($this->urlSwitching['block'])) {
    unset($urlsSwitching['block']);
}
if (empty($this->urlSwitching['table'])) {
    unset($urlsSwitching['table']);
}
if (empty($this->urlSwitching['map']) && isset($urlsSwitching['map'])) {
    unset($urlsSwitching['map']);
}

$modeListShow = $this->modeListShow ? $this->modeListShow : User::getModeListShow($urlsSwitching);

if (!Yii::app()->request->isAjaxRequest) {

    Yii::app()->clientScript->registerScript('search-params', "
		var updateText = '" . Yii::t('common', 'Loading ...') . "';
		var resultBlock = 'appartment_box';
		var bg_img = '" . Yii::app()->theme->baseUrl . "/images/pages/opacity.png';

		var useGoogleMap = " . param('useGoogleMap', 0) . ";
		var useYandexMap = " . param('useYandexMap', 0) . ";
		var useOSMap = " . param('useOSMMap', 0) . ";
			
		var modeListShow = " . CJavaScript::encode($modeListShow) . ";
		var urlsSwitching = " . CJavaScript::encode($urlsSwitching) . ";
		
		function setListShow(mode){
            modeListShow = mode;
            reloadApartmentList(urlsSwitching[mode]);
        };

        $(function () {
            if(modeListShow == 'map'){
                list.apply();
            }
        });
	", CClientScript::POS_BEGIN);

    // хз почему не работает, возможно из за owl галереи
    $script = <<< JS
    $('div#appartment_box').on('mouseover', 'div.appartment_item', function(event){
        if (event.type == 'mouseover') {
            console.log('over');
            $(this).find('div.apartment_item_edit').show();
        } else {
            console.log('out');
            $(this).find('div.apartment_item_edit').hide();
        }
    });
JS;

    //Yii::app()->clientScript->registerScript('search-edit', $script, CClientScript::POS_READY);
}

?>

<?php
if (empty($this->urlSwitching['block'])) {
    unset($urlsSwitching['block']);
}
if (empty($this->urlSwitching['table'])) {
    unset($urlsSwitching['table']);
}
if (empty($this->urlSwitching['map']) && isset($urlsSwitching['map'])) {
    unset($urlsSwitching['map']);
}

$countString = ($count && $showCount ? ' (' . $count . ')' : '');

$title = ($callFromWidget && $customWidgetTitle) ? $customWidgetTitle : ($this->widgetTitle ? $this->widgetTitle . $countString : '');

if ($title) {
    if (isset($isH1Widget) && $isH1Widget) {
        echo '<h1 class="fint">' . $title . '</h1>';
    } else {
        echo '<h3 class="h3 fint">' . $title . '</h3>';
    }
}
?>

<div class="catalog block" id="appartment_box">

    <?php if ($pages && 0): ?>
        <div class="pagination pagination-top">
            <?php
            $this->widget('CLinkPager', array(
                    'pages' => $pages,
                    'maxButtonCount' => 6,
                    'header' => '',
                    'selectedPageCssClass' => 'active',
//                'firstPageLabel'=>'<<',
//                'lastPageLabel'=>'>>',
                    'nextPageLabel' => '<i class="fas fa-long-arrow-right"></i>',
                    'prevPageLabel' => '<i class="fas fa-long-arrow-left"></i>',
//                'lastPageLabel'=>'Последняя',
//                'firstPageLabel'=>'Первая',
                    'hiddenPageCssClass' => 'disabled',
                    'htmlOptions' => array(
                        'class' => 'pagination',
                        'onClick' => 'reloadApartmentList(this.href); return false;'
                    ),
                )
            );

            ?>
        </div>
    <?php endif; ?>

    <?php
    $showSwitcher = $this->showSwitcher && $urlsSwitching;
    ?>

    <?php if ($showSwitcher || $showSorter) { ?>

        <div class="form-group row">

            <?php if ($showSwitcher) { ?>
                <div class="col-md-3 col-sm-3 col-xs-6 switcher-view-box">
                    <div class="btn-group">
                        <a href="<?php echo $urlsSwitching['block']; ?>"
                           class="btn btn-light <?php echo ($modeListShow == 'block') ? 'active' : ''; ?>"
                           onclick="setListShow('block'); return false;"><i class="fas fa-th-large"></i></a>
                        <a href="<?php echo $urlsSwitching['table']; ?>"
                           class="btn btn-light <?php echo ($modeListShow == 'table') ? 'active' : ''; ?>"
                           onclick="setListShow('table'); return false;"><i class="fas fa-table"></i></a>
                        <?php if (array_key_exists('map', $urlsSwitching)) : ?>
                            <a href="<?php echo $urlsSwitching['map']; ?>"
                               class="btn btn-light <?php echo ($modeListShow == 'map') ? 'active' : ''; ?>"><i
                                        class="fas fa-map-marker"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php } ?>

            <?php if ($showSorter) { ?>
                <div class="col-md-4 col-sm-4 col-xs-6 pull-right">
                    <?php $sorter->renderDropDownSorter(\application\modules\apartments\helpers\ApartmentsHelper::getSorterOptions($sorter)); ?>
                </div>
            <?php } ?>

        </div>

    <?php } ?>


    <?php if ($count): ?>
        <?php
        if ($modeListShow == 'block') {
            $this->render('widgetApartments_list_block', array('criteria' => $criteria));
        } elseif ($modeListShow == 'map' && (param('useGoogleMap', 0) || param('useYandexMap', 0) || param('useOSMMap', 0))) {
            $this->render('widgetApartments_list_map', array('criteria' => $criteria));
        } else {
            $this->render('widgetApartments_list_table', array('criteria' => $criteria));
        }
        ?>
        <div class="clear"></div>
    <?php endif; ?>
</div>

<?php if (!$count): ?>
    <div class="empty"><?php echo Yii::t('module_apartments', 'Apartments list is empty.'); ?></div>
    <div class="clear"></div>
<?php endif; ?>

<?php if ($pages): ?>
    <div class="pagination pagination-bottom">
        <?php
        $this->widget('DolphinPager', array(
                'pages' => $pages,
                'maxButtonCount' => 6,
                'header' => '',
                'selectedPageCssClass' => 'active',
                'nextPageLabel' => '<i class="fas fa-angle-right"></i>',
                'prevPageLabel' => '<i class="fas fa-angle-left"></i>',
                'firstPageLabel' => '<i class="fas fa-angle-double-left"></i>',
                'lastPageLabel' => '<i class="fas fa-angle-double-right"></i>',
                'htmlOptions' => array(
                    'class' => 'pagination',
                ),
                'htmlOption' => array('onClick' => 'reloadApartmentList(this.href); return false;'),
            )
        );

        ?>
    </div>
<?php endif; ?>
