<?php
if (Lang::isRTLLang(Yii::app()->language)) {
    HSite::LTRToRTLCssContent('/css/usercpanel.css');
} else {
    Yii::app()->clientScript->registerCssFile(Yii::app()->theme->baseUrl . '/css/usercpanel.css');
}
$this->aData['isUserpanel'] = true
?>

<?php $this->beginContent('//layouts/main'); ?>

<?php $this->aData['bodyClass'] = 'inner_page' ?>

    <div class="content main_content usercpanel">
        <?php if (issetModule('advertising')) : ?>
            <?php $this->renderPartial('//modules/advertising/views/advert-top', array()); ?>
        <?php endif; ?>

        <div class="content_center box">
            <div class="main-content-wrapper <?php echo ($this->htmlPageId == 'viewlisting') ? 'item-list' : 'content_entries'; ?>">
                <div class="usercpanel-right floatleft">
                    <?php
                    foreach (Yii::app()->user->getFlashes() as $key => $message) {
                        if ($key == 'error' || $key == 'success' || $key == 'notice') {
                            echo "<div class='flash-{$key}'>{$message}</div>";
                        }
                    }

                    ?>
                    <?php echo $content; ?>
                </div>
                <div class="clear"></div>
            </div>
        </div>
    </div>
<?php $this->endContent(); ?>