<!DOCTYPE html>
<?php
$isRTL = Lang::isRTLLang(Yii::app()->language);

$cs = Yii::app()->clientScript;
$cs->coreScriptPosition = CClientScript::POS_BEGIN;

$cs->defaultScriptFilePosition = CClientScript::POS_BEGIN;
$cs->defaultScriptPosition = CClientScript::POS_END;

$baseThemeUrl = Yii::app()->theme->baseUrl;
$baseThemePath = Yii::app()->theme->basePath;

DolphinAssets::register();

?>
<html lang="<?php echo Yii::app()->language; ?>">
<head>
    <title><?php echo HSeo::getTitle(); ?></title>
    <meta name="description" content="<?php echo HSeo::getDescription(); ?>"/>
    <meta name="keywords" content="<?php echo HSeo::getKeywords(); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= HSeo::getInstance()->getMetaRobotsNoindex() ?>
    <link rel="icon" href="<?php echo Yii::app()->request->getBaseUrl(true); ?>/favicon.ico" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo Yii::app()->request->getBaseUrl(true); ?>/favicon.ico"
          type="image/x-icon">

    <link href="https://fonts.googleapis.com/css?family=Roboto:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic"
          rel="stylesheet">
</head>

<body class="<?= isset($this->aData['bodyClass']) ? $this->aData['bodyClass'] : '' ?> <?php echo ($isRTL) ? 'rtl' : ''; ?>">

<?php if (demo()) : ?>
    <style>
        div.sidebar,
        div.col_right{
            padding-top: 42px;
        }
        .compare_block { padding-top: 33px; }
        .side-nav .compare_block {padding-top: 10px;}
        @media screen and (max-width: 800px) {
            div.sidebar, div.col_right {
                padding-top: 0px;
            }
            div.sidebar,
            div.col_right{
                padding-top: 0px;
            }
        }
    </style>
    <?php $this->renderPartial('//site/ads-block', array()); ?>
    <div class="clear"></div>
<?php endif; ?>

<?php if (isDev()) { (new HDev())->run(); } ?>

<?php require '_sidebar.php'; ?>

<div class="col_right">
    <?php require '_header.php' ?>
    <?php echo $content ?>
    <?php if (issetModule('advertising')) : ?>
        <?php $this->renderPartial('//modules/advertising/views/advert-bottom', array()); ?>
    <?php endif; ?>
    <?php require '_footer.php' ?>
</div>

<?php // hidden mobile menu ?>
<div class="side-nav" id="side-nav">
    <div class="wrapper-side" id="wrapper-side">
        <button type="button" class="close_btn_slide btn"><i class="far fa-times-circle"></i></button>
        <div class="slinky">
            <?php
            // $this->widget('DolphinMenuSlinky', array(
            //     'id' => 'slinky',
            //     'items' => Menu::getMenuItems(false, 3),
            //    //'htmlOptions' => array('class' => ''), //nav-pills
            //     'encodeLabel' => false,
            //     'activateParents' => true,
            //     'mobile' => true
            // ));
            ?>
            <?php
            $this->widget('DolphinMenuSlinky', array(
                'id' => 'slinky',
                'items' => Menu::getMenuItems(false, 4),
                'activeCssClass' => 'current',
                //'htmlOptions' => array('class' => ''),
                'encodeLabel' => false,
                'activateParents' => true,
                'mobile' => true,
            ));
            ?>
        </div>

        <div class="visible-xs">
            <div class="top_link_bl top_link_bl1 top_link_bl1__main">
                <?php
                if (issetModule('comparisonList')) {
                    $countComparison = ComparisonList::getCountIn();
                    ?>
                    <div class="top_link_bl compare_block">
                        <div <?php echo !$countComparison ? 'style="display: none"' : '' ?> id="comparison_top_header">
                            <a href="<?php echo Yii::app()->createUrl('comparisonList/main/index') ?>"
                               class="btn btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo Yii::t('common', '{n} in the comparison list', array('{n}' => $countComparison)) ?>
                            </a>
                        </div>
                    </div>
                <?php } ?>
                <ul class="list-inline list-inline__main text-left">
                    <li class="currency_block btn-group language_block currency_block__main">
                        <?php $this->widget('DolphinCurrencySelector'); ?>
                    </li>
                    <li class="btn-group language_block language_block__main">
                        <?php $this->widget('DolphinLangSelector'); ?>
                    </li>
                </ul>
                <ul class="list-inline list-inline__main text-left">
                    <li class="personal_cabinet personal_cabinet__main">
                        <div class="dropdown">
                            <button class="btn btn-info dropdown-toggle" type="button" id="dropdownMenuButton2Main"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-user-cog"></i> <?= Yii::t('common', 'Control panel') ?> <span
                                        class="caret"></span>
                            </button>
                            <?php
                            $this->widget('DolphinMenu', array(
                                'id' => 'main_menu_nav_main_2',
                                'items' => DolphinMenuHelper::getControlMenu(),
                                'htmlOptions' => array('class' => 'dropdown-menu'),
                                'encodeLabel' => false,
                                'activateParents' => true,
                            ));

                            ?>

                            <?php if (0) { ?>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="#">Войти</a></li>
                                    <li><a class="dropdown-item" href="#">Регистрация</a></li>
                                    <li><a class="dropdown-item" href="#">Забыли пароль?</a></li>
                                </ul>
                            <?php } ?>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="top_menu top_link_bl">
                <?php
                $headerTopMenuItems = Menu::getMenuItems(false, 3);
                if (!empty($headerTopMenuItems)) {
                    $this->widget('DolphinMenu', array(
                        'id' => 'main_menu_nav_main_1',
                        'items' => $headerTopMenuItems,
                        'htmlOptions' => array('class' => 'nav navbar-nav'),
                        'encodeLabel' => false,
                        'activateParents' => true,
                    ));
                } //else {
                //  echo '<div style="min-height: 68px; height: 68px;">&nbsp;</div>';
                // }
                ?>
            </div>
        </div>

    </div>
</div>
<div class="side-nav-overlay"></div>
</body>
</html>