<div class="footer">
    <div class="row">
        <div class="col-md-6 col-sm-6 footer_bl1">
            <div class="h3 fint"><?php echo tt('About us', 'theme_basis') ?></div>
            <div class="footer_content">
                <div class="row">
                    <div class="col-md-6 logo_footer">
                        <div class="logo">
                            <a href="<?= Yii::app()->createAbsoluteUrl('/') ?>">
                                <div class="logo-img"><img
                                            src="<?php echo $baseThemeUrl ?>/assets/images/logo.png"
                                            alt="<?php echo CHtml::encode(Yii::app()->name); ?>"></div>

                                <div class="logo-text"><?php echo CHtml::encode(Yii::app()->name); ?></div>
                            </a>
                        </div>
                    </div>
                    <div class="col-md-6 contact_footer">
                        <ul class="list-unstyled">
                            <li>
                                <i class="fas fa-envelope"></i> <?php echo $this->protectEmail(tt('index_email', 'theme_basis')) ?>
                            </li>
                            <li><i class="fab fa-skype"></i> <?php echo tt('index_skype', 'theme_basis') ?></li>
                            <li><i class="fas fa-phone"></i> <?php echo tt('index_phone', 'theme_basis') ?></li>
                        </ul>
                    </div>
                </div>
                <div class="about_product">
                    <p><?php echo tt('index_about_text', 'theme_basis') ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-3 footer_bl2">
            <?php $footerBottomMenuItems = Menu::getMenuItems(false, 5); ?>
            <?php if (!empty($footerBottomMenuItems)): ?>
                <div class="h3 fint"><?php echo tt('Helpful information', 'theme_basis') ?></div>
                <div class="footer_content">
                    <?php
                    $this->widget('DolphinMenu', array(
                        'id' => 'main_menu_nav',
                        'items' => $footerBottomMenuItems,
                        'htmlOptions' => array('class' => 'list-unstyled'),
                        'encodeLabel' => false,
                        'activateParents' => true,
                    ));

                    ?>
                </div>
            <?php endif; ?>
        </div>

        <div class="col-md-3 col-sm-3 footer_bl3 text-right">
            <div class="h3 fint"></div>
            <div class="footer_content">
                <ul class="list-unstyled">
                    <li><a href="<?php echo Yii::app()->createUrl('/booking/main/mainform') ?>"
                           class="slow btn btn-default fancy"><?php echo tt('Reserve apartment', 'common') ?></a></li>
                    <li class="plus"><a href="<?php echo Yii::app()->createUrl('/guestad/add') ?>"
                                        class="slow btn btn-primary"><?php echo tc('List your property') ?></a></li>
                    <li class="lk"><a href="<?php echo Yii::app()->createUrl('/usercpanel/main/index') ?>"
                                      class="slow btn btn-default"><?php echo Yii::t('common', 'Control panel') ?></a>
                    </li>
                </ul>
            </div>
            <?php
            if (param('useYandexShare', 0)) {
                echo "<div class='footer_share'>";
                $this->widget('application.extensions.YandexShareApi', array(
                    'services' => param('yaShareServices', 'yazakladki,moikrug,linkedin,vkontakte,facebook,twitter,odnoklassniki')
                ));
                echo "</div>";
            }

            if (param('useInternalShare', 1)) {
                echo "<div class='footer_share'>";
                $this->widget('ext.sharebox.EShareBox', array(
                    'url' => Yii::app()->getRequest()->getHostInfo() . Yii::app()->request->url,
                    'title' => CHtml::encode($this->seoTitle ? $this->seoTitle : $this->pageTitle),
                    'iconSize' => 24,
                    'include' => explode(',', param('intenalServices', 'vk,facebook,twitter,google-plus,stumbleupon,digg,delicious,linkedin,reddit,technorati,entriesvine')),
                ));
                echo "</div>";
            }
            ?>
        </div>
    </div>
</div>
<div class="footer_bottom">
    <div class="row">
        <?php echo getGA(); ?>
        <?php echo getJivo(); ?>
        <div class="col-md-6 col-sm-6">&copy; <?php echo CHtml::encode(Yii::app()->name); ?>,
            2011—<?php echo date('Y') ?>
            &nbsp;<img src="<?= $baseThemeUrl ?>/images/icons8-dolphin-26.png" alt="Dolphin theme"
                       title="Dolphin theme"> β
        </div>
        <div class="col-md-6 col-sm-6 text-right">
            <?php
            $vkUrl = Themes::getParamJson('i_vk');
            $fbUrl = Themes::getParamJson('i_facebook');
            $twUrl = Themes::getParamJson('i_twitter');
            if ($vkUrl || $fbUrl || $twUrl) {
                echo tt('We are in social networks', 'theme_basis') . ' — ';
                if ($vkUrl) echo '&nbsp;<a href="' . $vkUrl . '" target="_blank"><i class="fab fa-vk"></i></a>';
                if ($fbUrl) echo '&nbsp;<a href="' . $fbUrl . '" target="_blank"><i class="fab fa-facebook-f"></i></a>';
                if ($twUrl) echo '&nbsp;<a href="' . $twUrl . '" target="_blank"><i class="fab fa-twitter"></i></a>';
            }
            ?>
        </div>
    </div>
</div>

<div id="loading" style="display:none;"><?php echo Yii::t('common', 'Loading content...'); ?></div>
<div id="loading-blocks" style="display:none;"></div>
<div id="overlay-content" style="display:none;"></div>
<div id="toTop"><i class="fas fa-arrow-alt-circle-up"></i></div>

<?php
$cs->registerScript('main-vars', '
		var BASE_URL = ' . CJavaScript::encode(Yii::app()->baseUrl) . ';
		var CHANGE_SEARCH_URL = ' . CJavaScript::encode(Yii::app()->createUrl('/quicksearch/main/mainsearch/countAjax/1')) . ';
		var INDICATOR = "' . Yii::app()->theme->baseUrl . "/images/pages/indicator.gif" . '";
		var LOADING_NAME = "' . tc('Loading ...') . '";
		var params = {
			change_search_ajax: ' . param("change_search_ajax", 1) . '
		}
	', CClientScript::POS_BEGIN, array(), true);

$this->renderPartial('//layouts/_common');

$this->widget('application.modules.fancybox.EFancyBox', array(
        'target' => 'a.fancy',
        'config' => array(
            'ajax' => array('data' => "isFancy=true"),
            'titlePosition' => 'inside',
            'onClosed' => 'js:function(){
						var capClick = $(".get-new-ver-code");
						if(typeof capClick !== "undefined")	{ 
							capClick.click(); 
						}
					}'
        ),
    )
);

if (Yii::app()->user->checkAccess('apartments_admin')) {
    $cs->registerScriptFile(Yii::app()->theme->baseUrl . '/js/tooltip/jquery.tipTip.js', CClientScript::POS_END);
    $cs->registerScript('adminMenuToolTip', '
			$(function(){
				$(".adminMainNavItem").tipTip({maxWidth: "auto", edgeOffset: 10, delay: 200});
			});
		', CClientScript::POS_READY);

    ?>

    <div class="admin-menu-small slow <?php echo demo() ? 'admin-menu-small-demo' : ''; ?> ">
        <a href="<?php echo (Yii::app()->user->checkAccess('stats_admin') === true) ? Yii::app()->baseUrl . '/stats/backend/main/admin' : Yii::app()->baseUrl . '/apartments/backend/main/admin' ?>"
           title="<?php echo Yii::t('common', 'Administration'); ?>">
            <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px"
                 y="0px"
                 viewBox="0 0 45 42.1" style="enable-background:new 0 0 45 42.1;" xml:space="preserve">
        <title><?= Yii::t('common', 'Administration') ?></title>
                <g>
                    <g>
                        <path d="M28.5,24.6l-2.9-2.9l5.3-5.2h2.5c3.5,0,7.8-1.7,7.8-9.5V5.8L35,8.7l-2.1-2.2l2.7-6.3h-1.1c-7.9,0-9.5,4.2-9.5,7.8v2.5
            l-5.2,5.3l-8.6-8.6L13.4,5L5.1,0L2.9,2.2l5,8.3l2.3-2.3l8.6,8.6L1.5,34.3l-0.1,0.1L0,39.2l2.1,2L6.9,40l17.6-17.3l2.9,2.9
            l-2.1,2.1l14.4,14.4l5.2-5.2L30.6,22.5L28.5,24.6z M4.7,2.4l0.6-0.6l5.8,3.5l-3,3L4.7,2.4z M6.2,38.7l-3.7,0.9l-0.9-0.9l1.1-3.6
            l23.7-24.1V7.9c0-4,2.3-6,7-6.3l-2.2,5.1l3.5,3.6L39.7,8c-0.3,4.6-2.4,7-6.3,7h-3.1L6.2,38.7z M39.8,40.1L27.4,27.7l3.2-3.2
            L43,36.9L39.8,40.1z"/>
                    </g>
                </g>
</svg>
        </a>
    </div>
<?php } ?>

<?php
if (param('useShowInfoUseCookie') && isset(Yii::app()->controller->privatePolicyPage) && !empty(Yii::app()->controller->privatePolicyPage)) {
    $privatePolicyPage = Yii::app()->controller->privatePolicyPage;

    $message = CJavaScript::encode(CHtml::encode(Yii::app()->name) . ' ' . CHtml::encode(tc('uses cookie')) . ', <a href="' . $privatePolicyPage->getUrl() . '" target="_blank">' . $privatePolicyPage->getStrByLang('title') . '</a>');

    $cs->registerScript('display-info-use-cookie-policy', "
					$.cookieBar({/*acceptOnContinue:false, */ fixed: true, bottom: true, message: $message, acceptText : 'X'});
				", CClientScript::POS_READY);
}
?>

