<?php
if (issetModule('comparisonList')) {
    $urlAdd = Yii::app()->createUrl('/comparisonList/main/add');
    $urlDel = Yii::app()->createUrl('/comparisonList/main/del');
    $urlList = Yii::app()->createUrl('comparisonList/main/index');
    $maxCompareString = CJavaScript::encode(Yii::t("module_comparisonList", "max_limit", array('{n}' => param('countListingsInComparisonList', 6))));
    $errorString = CJavaScript::encode(tc("Error"));
    $inComparisonString = CJavaScript::encode(tt('In the comparison list', 'comparisonList'));
    $addToComparisonString = CJavaScript::encode(tt('Add to a comparison list ', 'comparisonList'));

    $script = <<< JS
    
    $('.main_content').on("click", ".compare-check", function() {
        var apId = $(this).attr("data-id");
        
        var isChecked = $('input.compare_check_'+apId).attr("checked") == "checked";
        if(isChecked){
            deleteCompare(apId);
        } else {
            addCompare(apId, this);
        }
    });

    function addCompare(apId, el) {
        $.ajax({
            type: "POST",
            url: '$urlAdd',
            data: {apId: apId, isJson: 1},
            dataType: 'json',
            success: function(data){
                if (data.status == "ok") {
                    showCompareBar(data);
                    compareAnimate(apId, el);
                    
                    $('.compare-label-'+apId).html($inComparisonString).prop("href", "$urlList"); //.attr("data-rel-compare", "true");
                    
                    $('input.compare_check_'+apId).attr("checked", "checked");
                }
                else {
                    $('input.compare_check_'+apId).removeAttr("checked");

                    if (data.error == "max_limit") {
                        error($maxCompareString);
                        //$('.compare-label-'+apId).html($maxCompareString);
                    }
                    else {
                        error($errorString);
                        //$('.compare-label-'+apId).html($errorString);
                    }
                }
            }
        });
    }

    function deleteCompare(apId) {
        $.ajax({
            type: "POST",
            url: "$urlDel",
            data: {apId: apId, isJson: 1},
            dataType: 'json',
            success: function(data){
                if (data.status == "ok") {
                    showCompareBar(data);
                    $('.compare-label-'+apId).html($addToComparisonString);
                    $('.compare-label-'+apId).prop("href", "javascript:void(0);");
                    
                    $('input.compare_check_'+apId).removeAttr("checked");
                }
                else {
                    $('input.compare_check_'+apId).attr("checked", "checked");
                    error($errorString);
                }
            }
        });
    }
        
    function compareAnimate(apId, el) {
      
        if($(el).attr('data-notAnimate') == 1){
            return;
        }  
        
        if(el){
            var that = $(el).parents('.apartment_item').find('img.slick-active');
        } else {
            var that = $('.ore-ap-'+apId).find('img.slick-active');
        }

        var bascket = $("#comparison_top");
        var w = that.width();

        that.clone()
            .css({
                'width': '100px',
                'height': '80px',
                'position': 'absolute',
                'z-index': '9999',
                top: that.offset().top,
                left: that.offset().left
            })
            .appendTo("body")
            .animate({
                opacity: 0.05,
                left: bascket.offset()['left'],
                top: bascket.offset()['top'],
                width: 20
            }, 1000, function () {
                $(this).remove();
            });
    }
    
    function showCompareBar(data) {
       if(data.count > 0){
           $('#comparison_top a, #comparison_top_header a').html(data.countString);
           $('#comparison_top, #comparison_top_header').show();
       } else {
           $('#comparison_top, #comparison_top_header').hide();
       }
    }
JS;


    Yii::app()->getClientScript()->registerScript('compare-functions-end', $script, CClientScript::POS_END, array(), false);
}

Yii::app()->getClientScript()->registerScript('callback-block-url-click', '
        $("#callback-block-url").click(function(e){
            e.preventDefault();
            
        });
', CClientScript::POS_READY);
