<?php
/** @var PopUnit $popUnit */

Yii::import('application.modules.themes.models.*');

$baseThemeUrl = Yii::app()->theme->baseUrl;

$itemsModels = $popUnit->getItemsModels();

$isNeedUploadListings = in_array(Themes::getParamJson('pd_upload'), array(DolphinDataForm::UPLOAD_BY_CRITERIA, DolphinDataForm::UPLOAD_ALL));

?>
    <div class="city_module">
        <div class="h3 fint text-center"><?= tt('Popular Destinations', 'basis_theme') ?></div>
        <div class="city-slick">
            <?php foreach ($itemsModels as $item) { ?>

                <?php $popUnitItem = new PopUnitItem($item); ?>
                <div class="item-city">
                    <img src="<?= $popUnitItem->getImageSrc('orig', 640, 440) ?>" alt="<?= $popUnitItem->getTitle() ?>">
                    <div class="text" data-id="<?= $popUnitItem->getId() ?>">
                        <div class="h3"><?= $popUnitItem->getTitle(true) ?></div>

                        <?= $popUnitItem->getListInline() ?>
                    </div>
                </div>
            <?php } ?>
        </div>

        <?php if ($isNeedUploadListings) { ?>
            <div id="result_city"></div>
        <?php } ?>
    </div>

<?php

$script = <<< JS
        //slick carousel for city module
        $('.city-slick').on('init', function (event, slick) {
            $('.item-city.slick-center img').addClass('animation-kenburns scale-kenburns');
        });
        $('.city-slick').slick({
            slidesToShow: 1,
            slidesToScroll: 1,
            autoplay: false,
            variableWidth: true,
            centerMode: true,
            centerPadding: '0',
            responsive: [
                {
                    breakpoint: 1199,
                    settings: {
                        centerPadding: '40px',
                    },
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: 1,
                        centerPadding: '0px',
                        arrows: false
                    },
                },
            ],
            infinite: true,
            prevArrow: '<button type="button" class="slick-prev slick-arrow slow"><i class="fas fa-chevron-left"></i></button>',
            nextArrow: '<button type="button" class="slick-next slick-arrow slow"><i class="fas fa-chevron-right"></i></button>',
        });

JS;

if ($isNeedUploadListings) {
    $urlUpload = Yii::app()->createUrl('/themes/widget/pdUploadAds');

    $needReload = Themes::getParamJson('pd_upload') == DolphinDataForm::UPLOAD_BY_CRITERIA ? 1 : 0;

    $script .= <<< JS

        getActiveCity();

        if($needReload){
            $('.city-slick').on('afterChange', function () {
                getActiveCity();
                $('.item-city.slick-center img').toggleClass('animation-kenburns scale-kenburns');
            });
        }
        
        $('.city-slick').on('beforeChange', function () {
            $('.item-city.slick-center img').toggleClass('animation-kenburns scale-kenburns');
        });

        function getActiveCity() {
            $.ajax({
                url: "$urlUpload",
                type: 'POST',
                dataType: 'html',
                data: {itemId: Math.abs($('.item-city.slick-slide.slick-active.slick-center .text').attr('data-id'))},
                success: function (data1) {
                    $('#result_city').html(data1);
                    $('.city-object-slick').on('init', function (event, slick) {
                        $('.item_obj.animated').addClass('activate fadeIn');
                    });
                    $('.city-object-slick').slick({
                        slidesToShow: 8,
                        infinite: true,
                        slidesToScroll: 1,
                        responsive: [
                            {
                                breakpoint: 1600,
                                settings: {
                                    slidesToShow: 6
                                }
                            },
                            {
                                breakpoint: 1199,
                                settings: {
                                    slidesToShow: 4,
                                }
                            },
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 4
                                }
                            },
                            {
                                breakpoint: 480,
                                settings: {
                                    slidesToShow: 2,
                                    arrows: false,
                                }
                            }
                        ],
                        centerMode: false,
                        infinite: true,
                        arrows: true,
                        prevArrow: '<button type="button" class="slick-prev slick-arrow slow"><i class="fas fa-chevron-left"></i></button>',
                        nextArrow: '<button type="button" class="slick-next slick-arrow slow"><i class="fas fa-chevron-right"></i></button>',
                    });
                }
            });
        }
JS;

}

Yii::app()->clientScript->registerScript('slick-pd-init-js', $script, CClientScript::POS_END);
?>


<?php if (0) { ?>
    <div class="widget box popular-block">
        <div class="box-header h4"><?= tt('Popular Destinations', 'basis_theme') ?></div>
        <div class="box-content">

            <div class="row">
                <?php
                $objTypesList = ApartmentObjType::getListForSearch();

                foreach ($cities as $city) {
                    $imgSrc = $city->image ? $city->image->getThumbHref(150, 115) : Yii::app()->baseUrl . '/uploads/150x100_no_photo_img.png';
                    $imgAlt = ($city->image && $city->image->seo) ? $city->image->seo->alt : '';
                    $cityUrlField = 'url_' . Yii::app()->language;
                    $cityUrl = ($city->seo && $city->seo->{$cityUrlField}) ? $city->seo->{$cityUrlField} : 'javascript:;';

                    ?>
                    <div class="item-popular col-md-12 col-sm-6">
                        <div class="row">
                            <div class="col-md-4 col-sm-4">
                                <img src="<?= $imgSrc ?>" alt="<?= $imgAlt ?>">
                            </div>
                            <div class="col-md-8 col-sm-8">
                                <ul class="list-unstyled">
                                    <li class="city_name">
                                        <a href="<?= $cityUrl ?>"><?= $city->name ?></a>
                                        <ul class="list-inline">
                                            <?php foreach ($objTypesList as $objTypeId => $objTypeName) { ?>
                                                <?php $url = Yii::app()->createUrl('/search', array('objType' => $objTypeId, 'city[]' => $city->id)) ?>
                                                <li><a href="<?= $url ?>"><?= $objTypeName ?></a></li>
                                            <?php } ?>
                                        </ul>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

        </div>
    </div>

<?php } ?>