<?php $baseThemeUrl = Yii::app()->theme->baseUrl; ?>

<div class="box widget">
    <div class="h3 fint l_fint"><?php echo tc('News') ?></div>

    <div class="news_content row">
        <?php foreach ($this->entries as $entries) { ?>
            <?php
            $src = Yii::app()->theme->baseUrl . '/assets/images/news_no_photo_272x181.jpg';
            if ($entries->image) {
                $src = Yii::app()->getBaseUrl() . '/uploads/entries/' . $entries->image->getThumb(348, 200, true);
            }
            $title = $entries->getStrByLang('title');
            $url = $entries->getUrl();
            $announce = ($entries->getAnnounce()) ? $entries->getAnnounce() : '&nbsp;';
            $tagLinks = $entries->getTagLinks();

            ?>
            <div class="item_news col-sm-3">
                <div class="img_news">
                    <a href="<?php echo $url ?>" style="background-image:url(<?= $src; ?>);"></a>
                    <?php if ($tagLinks) { ?>
                        <ul class="list-inline tags">
                            <?php foreach ($tagLinks as $link) { ?>
                                <li><?php echo $link ?></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>

                </div>
                <div class="h4">
                    <a href="<?php echo $url ?>"><?php echo $title ?></a><span
                            class="date_news"><?= $entries->getDateTimeInFormat('date_created') ?></span>
                </div>

                <div class="text_news"><p><?php echo truncateText($announce, 20); ?></p></div>
            </div>
        <?php } ?>
    </div>
</div>