<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    google.charts.load('current', {'packages': ['corechart']});
</script>
<?php
Yii::app()->getModule('userads');

$this->pageTitle .= ' - ' . tc('My listings');

if (!isset($this->breadcrumbs) || empty($this->breadcrumbs)) {
    $this->breadcrumbs = array(
        Yii::t('common', 'Control panel') => array('/usercpanel/main/index'),
        tt('Manage apartments', 'apartments')
    );
}

echo BasisUserPanelHelper::title(tc('My listings'));

?>
<div class="clear"></div><br/>

<div class="flashes" style="display: none;"></div>
<div class="buttons-listing">
    <div class="additional-add-listing">
        <?php echo CHtml::link(tc('Add ad'), Yii::app()->createUrl('/userads/main/create'), array('class' => 'btn btn-primary')); ?>

        <?php echo CHtml::link(tc('Filter'), 'javascript: void(0);', array('class' => 'btn btn-info', 'id' => 'search-listview-button')); ?>

        <?php echo CHtml::link(tt('Drafts', 'apartments'), Yii::app()->createUrl('/userads/main/drafts'), array('class' => 'btn btn-warning')); ?>
    </div>
    <div class="clear"></div>
</div>


<div class="search-my-listings-form" style="display:none">
    <?php
    $this->renderPartial('//modules/userads/views/_search', array(
        'model' => $model,
    ));

    ?>
</div>
<div class="clear"></div><br/>

<?php
$this->widget('NoBootstrapListView', array(
    'afterAjaxUpdate' => 'function(){ if(typeof initBootstrapConfirm === "function"){initBootstrapConfirm();} }',
    'dataProvider' => $model->search(),
    'itemView' => '//modules/userads/views/_view_listing',
    'viewData' => array(),
    'itemsTagName' => 'ol',
    'itemsCssClass' => 'my-listing-blocks',
    'id' => 'my-listing-blocks',
    'sortableAttributes' => array(),
));

//Yii::app()->clientScript->registerCssFile(Yii::app()->request->baseUrl . '/common/css/bootstrap.min.css');
//Yii::app()->clientScript->registerScriptFile(Yii::app()->request->baseUrl . '/common/js/bootstrap.min.js', CClientScript::POS_BEGIN);
Yii::app()->clientScript->registerScriptFile(Yii::app()->request->baseUrl . '/common/js/bootstrap-confirmation.min.js', CClientScript::POS_END);

?>

<style>
    #fancybox-content {
        width: auto !important;
    }
</style>

<script>
    function initBootstrapConfirm() {
        $('[data-toggle=confirmation]').confirmation({
            rootSelector: '[data-toggle=confirmation]'
            /*rootSelector: '[data-toggle=confirmation]',
            btnOkIcon: '',
            btnOkIconClass: '',
            btnCancelIcon: '',
            btnCancelIconClass: ''*/
        });
    }

    $(document).ready(function () {
        initBootstrapConfirm();
    });
</script>

<?php
Yii::app()->clientScript->registerScript('search', "
	$('#search-listview-button').click(function(){
		$('.search-my-listings-form').toggle();
		
		if ($('.search-my-listings-form').css('display') == 'none') {
			$('#search-listview-button').html('" . tc('Filter') . "');
		}
		else {
			$('#search-listview-button').html('" . tc('Hide filter') . "');
		}
		return false;
	});

	$('.search-my-listings-form form').submit(function(){
		$.fn.yiiListView.update('my-listing-blocks', {
			data: $(this).serialize()
		});
		return false;
	});
", CClientScript::POS_END);
