<?php
$this->pageTitle .= ' - ' . tt("FAQ");
$this->breadcrumbs = array(
    tt("FAQ"),
);

?>

    <div class="title highlight-left-right">
        <div>
            <h1><?php echo tt("FAQ"); ?></h1>
        </div>
    </div>
    <div class="clear"></div><br/>

    <div class="block_entries">
        <?php if ($articles): ?>
            <div class="b_entries">
                <?php foreach ($articles as $article) : ?>
                    <div class="b_entries__item b_entries__item_no_src">
                        <div class="b_entries__item_post b_entries__item_post_no_src">
                            <div class="title">
                                <?php echo CHtml::link($article['page_title'], $article->getUrl(), array('class' => 'title')); ?>
                            </div>
                            <br/>
                            <div class="new_desc">
                                <?php echo truncateText($article['page_body'], 50); ?>
                            </div>
                            <?php echo CHtml::link(Yii::t('module_articles', 'Read more &raquo;'), $article->getUrl(), array('class' => 'read_more')) ?>
                        </div>
                    </div>
                    <div class="clear"></div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="clear"></div>

<?php if ($pages && $pages->pageCount > 1): ?>
    <div class="pagination pagination-bottom">
        <?php
        $this->widget('BasisPager', array(
            'pages' => $pages,
            'maxButtonCount' => 6,
            'header' => '',
            'selectedPageCssClass' => 'active',
            'nextPageLabel' => '<i class="fas fa-angle-right"></i>',
            'prevPageLabel' => '<i class="fas fa-angle-left"></i>',
            'firstPageLabel' => '<i class="fas fa-angle-double-left"></i>',
            'lastPageLabel' => '<i class="fas fa-angle-double-right"></i>',
            'htmlOptions' => array(
                'class' => 'pagination',
            ),
        ));
        ?>
    </div>
    <div class="clear"></div>
<?php endif; ?>