<?php
$isRTL = Lang::isRTLLang(Yii::app()->language);

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo Yii::app()->language; ?>"
      lang="<?php echo Yii::app()->language; ?>">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <title><?php echo CHtml::encode($this->seoTitle ? $this->seoTitle : $this->pageTitle); ?></title>
    <meta name="description"
          content="<?php echo CHtml::encode($this->seoDescription ? $this->seoDescription : $this->pageDescription); ?>"/>
    <meta name="keywords"
          content="<?php echo CHtml::encode($this->seoKeywords ? $this->seoKeywords : $this->pageKeywords); ?>"/>

    <?php Yii::app()->clientScript->registerCssFile(Yii::app()->theme->baseUrl . '/css/form.css', 'screen'); ?>
    <link href='https://fonts.googleapis.com/css?family=PT+Sans+Narrow:400,700&subset=cyrillic-ext,latin,latin-ext,cyrillic'
          rel='stylesheet' type='text/css'>

    <!--<link rel="stylesheet" type="text/css" href="<?php echo Yii::app()->theme->baseUrl; ?>/css/form.css" />-->

    <?php
    if ($isRTL) {
        HSite::LTRToRTLCssContent('/assets/css/print.css', 'screen, print');
    } else {
        Yii::app()->clientScript->registerCssFile(Yii::app()->theme->baseUrl . '/assets/css/print.css', 'screen, print');
    }

    ?>

    <?php BasisAssets::register(); ?>

    <link rel="icon" href="<?php echo Yii::app()->request->getBaseUrl(true); ?>/favicon.ico" type="image/x-icon"/>
    <link rel="shortcut icon" href="<?php echo Yii::app()->request->getBaseUrl(true); ?>/favicon.ico"
          type="image/x-icon"/>
</head>

<body>
<div id="container">

    <div class="content print-version">
        <?php echo $content; ?>
        <div class="clear"></div>
    </div>
</div>
</body>
</html>