<?php
if (empty($citiesListResult)) {
    return;
}

$i = 0;

?>
<div class="widget box popular-block or-page">
    <?php
    if(HUser::isAdminOrModerator()){
        $editUrl = Yii::app()->createUrl('/themes/backend/widget/popularDest', ['id' => Themes::getParam('id')]);
        echo CHtml::link('<i class="fa fa-edit or-edit-page" title="'.tc('Edit').'"></i>', $editUrl);
    }
    ?>

    <div class="box-header h4"><?= tt('Popular Destinations', 'basis_theme') ?></div>
    <div class="box-content">

        <div class="row">
            <?php
            $citiesListResult = sortArrByKeysAnotherArrDesc($citiesListResult, array_keys(sortArrByValuesCountDesc($countApartmentsByCategories)));
            ?>

            <?php foreach ($citiesListResult as $cityId => $cityValue) { ?>
                <?php
                if ($i >= 4) {
                    break;
                }
                if (issetModule('location')) {
                    $city = City::model()->findByPk($cityId);
                } else {
                    $city = ApartmentCity::model()->findByPk($cityId);
                }
                if (!$city) {
                    continue;
                }
                $imgSrc = $city->image ? $city->image->getThumbHref(150, 115) : Yii::app()->baseUrl . '/common/images/150x100_no_photo_city.jpg';
                $imgAlt = ($city->image && $city->image->seo) ? $city->image->seo->alt : '';
                ?>
                <div class="item-popular col-md-12 col-sm-6">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                            <img src="<?= $imgSrc ?>" alt="<?= $imgAlt ?>">
                        </div>
                        <div class="col-md-8 col-sm-8">
                            <ul class="list-unstyled">
                                <li class="city_name">
                                    <?php
                                    echo CHtml::link(
                                        $cityValue[Yii::app()->language]['name'],
                                        HSeo::getCityUrlById($cityId)
                                    ); ?>
                                    <ul class="list-inline">
                                        <?php
                                        foreach ($objTypesListResult as $objTypeId => $objValue) {
                                            $link = HSeo::getCityObjTypeLinkById($cityId, $objTypeId);
                                            if ($link) {
                                                echo CHtml::tag('li', array(), $link);
                                            }
                                        }
                                        ?>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php $i++; ?>
            <?php } ?>

        </div>

    </div>
</div>





