<?php
/** @var PopUnit $popUnit */

Yii::import('application.modules.themes.models.*');

$baseThemeUrl = Yii::app()->theme->baseUrl;

$itemsModels = $popUnit->getItemsModels();
?>

<div class="widget box popular-block or-page">
    <?php
    if(HUser::isAdminOrModerator()){
        $editUrl = Yii::app()->createUrl('/themes/backend/widget/popularDest', ['id' => Themes::getParam('id')]);
        echo CHtml::link('<i class="fa fa-edit or-edit-page" title="'.tc('Edit').'"></i>', $editUrl);
    }
    ?>

    <div class="box-header h4"><?= tt('Popular Destinations', 'basis_theme') ?></div>
    <div class="box-content">

        <div class="row">
            <?php foreach ($itemsModels as $item) { ?>

                <?php $popUnitItem = new PopUnitItem($item); ?>

                <div class="item-popular col-md-12 col-sm-6">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                            <img src="<?= $popUnitItem->getImageSrc('orig', 150, 115) ?>"
                                 alt="<?= $popUnitItem->getTitle(false) ?>">
                        </div>
                        <div class="col-md-8 col-sm-8">
                            <ul class="list-unstyled">
                                <li class="city_name">
                                    <?= $popUnitItem->getTitle(true) ?>
                                    <?= $popUnitItem->getListInline() ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

            <?php } ?>

        </div>

    </div>
</div>