<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class BasisPopularDestWidget extends CWidget
{

    public $showWidgetTitle = true;
    public $params = null;
    public $customWidgetTitle;
    public $widgetTitles;

    public function run()
    {
        $popUnit = self::getPopUnit();

        if ($popUnit) {
            $this->render('popular_dest', array('popUnit' => $popUnit));
        } else {
            $this->defaultView();
        }

    }

    public function defaultView()
    {
        $citiesListResult = $objTypesListResult = $resCounts = array();
        if (issetModule('seo')) {
            $citiesListResult = SeoFriendlyUrl::getActiveCityRoute($this->params);
            $objTypesListResult = SeoFriendlyUrl::getActiveObjTypesRoute($this->params, true, true);
            $resCounts = SeoFriendlyUrl::getCountApartmentsForCategories($this->params);
        }

        $countApartmentsByCategories = array();
        if (!empty($resCounts)) {
            foreach ($resCounts as $values) {
                $countApartmentsByCategories[$values['city']][$values['obj_type_id']] = $values['count'];
            }
        }
        unset($resCounts);

        $subTitleKey = InfoPages::getWidgetSubTitleKey('seosummaryinfo');
        $this->customWidgetTitle = InfoPages::getWidgetSubTitle($subTitleKey, $this->widgetTitles);

        if (empty($this->customWidgetTitle)) {
            $this->showWidgetTitle = false;
        }

        $this->render('popular_dest_seo', array(
                'citiesListResult' => $citiesListResult,
                'objTypesListResult' => $objTypesListResult,
                'countApartmentsByCategories' => $countApartmentsByCategories,
                'params' => $this->params,
                'showWidgetTitle' => $this->showWidgetTitle,
                'customWidgetTitle' => $this->customWidgetTitle
            )
        );
    }


    public static function getPopUnit()
    {
        Yii::import('application.modules.themes.helpers.*');

        $type = Themes::getParamJson('popular_dest_type');

        switch ($type) {
            case PopUnit::TYPE_LOCATIONS:
            case PopUnit::TYPE_INFOPAGES:
            case PopUnit::TYPE_CITIES:

                $popUnit = PopFactory::getUnit($type, Themes::getParam('id'));
                return $popUnit;
                break;

            case PopUnit::TYPE_DEFAULT:
            default:

                return null;
                break;
        }
    }
}
