<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class BasisHotAdsWidget extends CWidget
{
    public $objIds = [1, 2, 5, 6];
    public $limit = 6;

    private $theme;

    public function init()
    {
        $this->theme = Themes::model()->findByPk(Themes::getParam('id'));

        if (!$this->theme) {
            throw new CHttpException('Bad theme param', 400);
        }

        $this->objIds = $this->theme->getFromJson('hotObjTypeIds', $this->objIds);
        $this->limit = $this->theme->getFromJson('hotLimit', $this->limit);
    }

    /**
     * @throws CException
     */
    public function run()
    {
        if (!$this->objIds || !is_array($this->objIds)) {
            return;
        }

        if (empty($tabsData = $this->getTabsData())) {
            return;
        }

        $this->render('hot_ads', array(
            'tabsData' => $tabsData
        ));
    }

    public function getTabsData()
    {
        $objTypeList = ApartmentObjType::getList();
        $data = array();

        foreach ($this->objIds as $objId) {
            if (isset($objTypeList[$objId])) {
                $ads = self::getModelsForObjId($objId, $this->limit);
                if($ads) {
                    $data[$objId]['ads'] = self::getModelsForObjId($objId, $this->limit);
                    $data[$objId]['name'] = $objTypeList[$objId];
                }
            }
        }

        return $data;
    }

    /**
     * @param $objId
     * @param int $limit
     * @return mixed
     */
    private function getModelsForObjId($objId, $limit = 6)
    {
        $criteria = new CDbCriteria();
        $criteria->addCondition('t.active = 1 AND t.owner_active = 1 AND t.deleted = 0 ');
        $criteria->order = 't.sorter DESC, t.is_special_offer DESC, t.date_created DESC';
        $with = array('images');
        if (issetModule('seo')) {
            $with = CMap::mergeArray($with, array('seo'));
        }
        $criteria->with = $with;
        $criteria->compare('t.obj_type_id', $objId);

        $criteria->addInCondition('t.type', HApartment::availableApTypesIds());
        $criteria->addCondition('(t.price_type IN (' . implode(',', array_keys(HApartment::getPriceArray(Apartment::PRICE_SALE, true))) . ') OR t.is_price_poa = 1)');

        $criteria = HGeo::setForIndexCriteria($criteria);

        $criteria->limit = $limit;

        return Apartment::model()->with($with)->findAll($criteria);
    }
}
