
<?php

$columns = array(
    array(
        'class' => 'CCheckBoxColumn',
        'id' => 'id',
        'value' => '$data->id',
        //'checked' => 'is_array($data->itemsSelectedExport) ? in_array($data->id, $data->itemsSelectedExport) : false'
        'checked' => '$data->id ? true : false',
        'checkBoxHtmlOptions' => [
            'checked' => 'checked',
            'data-test' => 1
        ],
    ),
    array(
        'name' => 'id',
        'htmlOptions' => array(
            'class' => 'apartments_id_column',
            'style' => 'text-align: center;',
        ),
        'sortable' => false,
    ),
    array(
        'name' => 'type',
        'type' => 'raw',
        'value' => 'HApartment::getNameByType($data->type)',
        'htmlOptions' => array(
            'style' => 'width: 100px;',
        ),
        'filter' => HApartment::getTypesArray(), //CHtml::dropDownList('Apartment[type_filter]', $currentType, HApartment::getTypesArray(true)),
        'sortable' => false,
    ),
);

if (issetModule('location')) {
    $columns[] = array(
        'name' => 'loc_country',
        'value' => '$data->locCountry ? $data->locCountry->name : ""',
        'htmlOptions' => array(
            'style' => 'width: 150px;',
        ),
        'sortable' => false,
        'filter' => Country::getCountriesArray(0, 1),
    );
    $columns[] = array(
        'name' => 'loc_region',
        'value' => '$data->locRegion ? $data->locRegion->name : ""',
        'htmlOptions' => array(
            'style' => 'width: 150px;',
        ),
        'sortable' => false,
        'filter' => Region::getRegionsArray($modelAps->loc_country, 0, 1),
    );
    $columns[] = array(
        'name' => 'loc_city',
        'value' => '$data->locCity ? $data->locCity->name : ""',
        'htmlOptions' => array(
            'style' => 'width: 150px;',
        ),
        'sortable' => false,
        'filter' => City::getCitiesArray($modelAps->loc_region, 0, 1),
    );
} else {
    $columns[] = array(
        'name' => 'city_id',
        'value' => '(isset($data->city ) && $data->city_id) ? $data->city->name : ""',
        'htmlOptions' => array(
            'style' => 'width: 150px;',
        ),
        'filter' => ApartmentCity::getAllCity(),
        'sortable' => false,
    );
}

$columns[] = array(
    'name' => 'ownerEmail',
    'htmlOptions' => array(
        'style' => 'width: 150px;',
    ),
    'type' => 'raw',
    'value' => '(isset($data->user) && $data->user->role != "admin") ? CHtml::link(CHtml::encode($data->user->email), array("/users/backend/main/view","id" => $data->user->id)) : tt("administrator", "common")',
);

$columns[] = array(
    'header' => tc('Name'),
    'name' => 'title_' . Yii::app()->language,
    'type' => 'raw',
    'value' => 'CHtml::link(CHtml::encode($data->{"title_".Yii::app()->language}), $data->getUrl())',
    'sortable' => false,
);

?>

<div class="form">
    <?php
    $this->widget('CustomHistoryGridView', array(
        'id' => 'export-grid',
        'dataProvider' => $modelAps->searchExport(),
        //'filter' => $modelAps,
        'selectableRows' => 2,
        'selectionChanged' => 'js:selItemsSelected',
        'columns' => $columns,
    ));

    echo $form->hiddenField($model, 'itemsSelected', ['id' => 'itemsSelected']);
    ?>
</div><!-- form -->

<script>
    function selItemsSelected() {
        var arraySel = $("#export-grid").selGridView("getAllSelection");
        var stringSel = arraySel.join(',');
        $('#itemsSelected').val(stringSel);
    }
</script>
