<?php
/* @var $this MainController */
/* @var $model YandexList */
/* @var $modelAps Apartment */
/* @var $form CActiveForm */
?>

<div class="form" id="yandex-xml-form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'yandex-list-form',
	'enableAjaxValidation'=>false,
)); ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

	<?php echo $form->errorSummary($model); ?>

	<div class="row-old">
		<?php echo $form->labelEx($model,'name'); ?>
		<?php echo $form->textField($model,'name',array('size'=>60,'maxlength'=>255, 'class' => 'form-control')); ?>
		<?php echo $form->error($model,'name'); ?>
	</div>

    <br/>

    <?php

    $this->widget(\application\modules\apartments\widgets\SearchFormWidget::class, array(
        'model' => $modelAps,
        'isUseForm' => false,
        'isShowForm' => true,
        'isShowApplyButton' => false,
        'isShowClearButton' => false,
        'searchFields' => ['ownerEmail', 'title', 'type', 'obj_type_id', 'price', 'floor', 'square', 'rooms', 'ot', 'photo'],
        'typeList' => HApartment::getTypesListForYandex(),
        'objectTypeList' => \CArray::merge(array(0 => ''), ApartmentObjType::getList('yandex')),
    ));

    echo '<br/>';

    //include '_form_list.php';
    ?>

	<div class="row-old buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Create') : tc('Save'), [
            'onclick' => 'if(!doSubmitForm()) alert("tst");'
        ]);
        ?>
	</div>

<?php $this->endWidget(); ?>

</div><!-- form -->

<?php
$script = <<< JS
    
    function doSubmitForm() {
        $('#yandex-xml-form input, #yandex-xml-form select').each(function() {
            var val = $(this).val();
            var disable = (!val || val == null || val == 0);
            if(disable){
                $(this).prop('disabled', 'disabled');
            }
        });
        return true;
    }
JS;

Yii::app()->getClientScript()->registerScript('js-search-filter-do', $script, \CClientScript::POS_END);

?>