<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */
namespace application\modules\yandexRealty\services;

use application\modules\yandexRealty\repositories\YandexRealtyRepository;
use Yii;

class YandexRealtyService
{
    public $modelName = 'YandexRealty';
    public $defaultAction = 'viewfeed';
    public $generationDate;
    public $country;
    public $region;
    public $currency;

    public static $squareUnit = 'кв.м';
    public static $landSquareUnit = 'соток';

    # http://help.yandex.ru/webmaster/?id=1113400
    # Сейчас принимаются объявления только о продаже и аренде жилой недвижимости: квартир, комнат, домов и участков.
    # http://help.yandex.ru/realty/actual.xml
    # актуальные объявления
    # для продажи квартир на вторичке — созданные не более 90 дней назад, либо обновлённые не более 45 дней назад;
    # для длительной аренды квартир — созданные не более 7 дней назад, либо обновлённые не более 14 дней назад;
    # для продажи комнат — созданные не более 120 дней назад, либо обновлённые не более 45 дней назад;
    # для длительной аренды комнат — созданные не более 25 дней назад, либо обновлённые не более 24 дней назад;
    # для длительной аренды домов — созданные не более 30 дней назад, либо обновлённые не более 30 дней назад;
    # проверка файла - http://webmaster.yandex.ru/xsdtest.xml
    # общие условия размещения объявлений - http://help.yandex.ru/webmaster/?id=1113378

    public static $typeApartment = array('квартира', 'flat');
    public static $typeHouse = array('дом', 'house', 'дом с участком', 'house with lot');
    public static $typeRoom = array('комната', 'room');
    public static $typeLand = array('участок', 'lot');
    public static $typeGarage = array('гараж', 'garage');
    public static $typeOffice = array('office');
    public static $typeHotel = array('hotel');

    private $adsWithoutDateCriteria = [];
    private $errorByType = 0;
    private $errorByDate = 0;
    private $errorByRoom = 0;

    public function __construct()
    {
        # php.ini - date.timezone
        $this->generationDate = date('c', time());

        # если нет модуля "Страна->регион->город" задаём строго
        $this->country = 'Россия';
        $this->region = 'Москва и московская область';

        # валюта
        $this->currency = 'RUR'; # param('siteCurrency', 'RUR');

        if (!isFree()) {
            $activeCurrencyId = \Currency::getDefaultValuteId();
            $activeCurrency = \Currency::model()->findByPk($activeCurrencyId);
            $this->currency = ($activeCurrency && isset($activeCurrency->char_code)) ? $activeCurrency->char_code : $this->currency;
        }
    }

    public function getFeedItems($criteria = null)
    {
        $repository = new YandexRealtyRepository();

        if($criteria){
            $this->adsWithoutDateCriteria = $repository->getAdsWithoutDateCriteria($criteria);
        } else {
            $this->adsWithoutDateCriteria = $repository->getAdsWithoutDateCriteria();
        }

        if (!is_array($this->adsWithoutDateCriteria) || empty($this->adsWithoutDateCriteria)) {
            return [];
        }

        $this->errorByType = $this->errorByDate = $this->errorByRoom = 0;

        $objTypes = \ApartmentObjType::getYANTypes();

        foreach ($this->adsWithoutDateCriteria as $preKey => $preAd) {

            $this->adsWithoutDateCriteria[$preKey]['obj_type'] = $objTypes[$preAd['obj_type_id']];

            // проверки ниже только для жилой недвижимости
            if ($preAd['ya_type'] != \YandexRealty::YA_TYPE_LIVE) {
                continue;
            }

            // только день, месяц
            if (issetModule('seasonalprices') && $preAd['type'] == \Apartment::TYPE_RENT) {
                $preAd['price_type'] = $preAd['price_type_rent'];
            }

            if (!in_array($preAd['price_type'], array(\Apartment::PRICE_PER_DAY, \Apartment::PRICE_PER_MONTH, \Apartment::PRICE_SALE))) {
                $this->errorByType++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                continue;
            }

            # подборка по дате создания / обновления для импорта в яндекс недвижимость
            if(!$criteria){
                $this->clearByDate($preAd, $preKey);
            }
        }

        $activeAds = $this->adsWithoutDateCriteria;

        unset($this->adsWithoutDateCriteria);
        ########################################################################

//        if (count($activeAds) < 10) {
//            $this->showError($activeAds, $countActive);
//        }

        foreach ($activeAds as $ad) {
            $allIds[] = $ad['id'];
        }

        if (isset($allIds) && is_array($allIds)) {
            $sqlImages = 'SELECT id, id_object, id_owner, file_name, file_name_modified, is_main, sorter FROM {{images}} WHERE id_object IN(' . implode(', ', $allIds) . ')';
            $resImages = Yii::app()->db->createCommand($sqlImages)->queryAll();

            $sqlReferences = '
				SELECT reference.apartment_id as refApartmentId, reference_values.title_' . Yii::app()->language . ' as refName, reference_values.id as refValueId
				FROM {{apartment_reference}} reference
				INNER JOIN {{apartment_reference_values}} reference_values ON reference_values.id = reference.reference_value_id
				WHERE reference.apartment_id IN (' . implode(', ', $allIds) . ')
			';
            $resReferences = Yii::app()->db->createCommand($sqlReferences)->queryAll();

            $activeAds = array_combine($allIds, $activeAds);
            if ($resImages && is_array($resImages)) {
                foreach ($resImages as $rImage) {
                    if (isset($activeAds[$rImage['id_object']])) {
                        $activeAds[$rImage['id_object']]['images'][] = $rImage;
                    }
                }

                unset($sqlImages, $resImages);
            }

            if ($resReferences && is_array($resReferences)) {
                foreach ($resReferences as $rRef) {
                    if (isset($activeAds[$rRef['refApartmentId']])) {
                        $activeAds[$rRef['refApartmentId']]['reference'][$rRef['refValueId']] = $rRef['refName'];
                    }
                }

                unset($sqlReferences, $resReferences);
            }

            if (issetModule('metroStations')) {
                $sqlMetros = 'SELECT ams.apartment_id as refApartmentId, ms.name_' . Yii::app()->language . ' as metroName, ms.id as metroId
					FROM {{apartment_metro_stations}} ams, {{metro_stations}} ms
					WHERE ams.metro_id = ms.id AND ams.apartment_id IN (' . implode(', ', $allIds) . ')';
                $resMetros = Yii::app()->db->createCommand($sqlMetros)->queryAll();

                if ($resMetros && is_array($resMetros)) {
                    foreach ($resMetros as $rMetro) {
                        if (isset($activeAds[$rMetro['refApartmentId']])) {
                            $activeAds[$rMetro['refApartmentId']]['metros'][$rMetro['metroId']] = $rMetro['metroName'];
                        }
                    }

                    unset($sqlMetros, $resMetros);
                }
            }

            unset($allIds);
        }

        return $activeAds;
    }

    private function showError($activeAds, $countActive)
    {
        echo 'Актуальных объявлений меньше 10. Всего:' . count($activeAds);
        echo '<br><br>Из ' . $countActive . ' активных объявлений на сайте не подходят по критериям:';
        if ($this->errorByType)
            echo '<br>' . $this->errorByType . ' т.к. допускаются только - продажа, аренда постуточно и помесячно';
        if ($this->errorByDate)
            echo '<br>' . $this->errorByDate . ' по дате создания / обновления';
        if ($this->errorByRoom)
            echo '<br>' . $this->errorByRoom . ' для квартир не указано кол-во комнат';
        echo '<br><br>Если есть объявления от администратора - проверьте указание телефона, т.к это поле обязательное.';
        echo '<br><br><a href="http://help.yandex.ru/realty/actual.xml" target="_blank">http://help.yandex.ru/realty/actual.xml</a>';
        echo '<br><a href="http://help.yandex.ru/webmaster/?id=1113400" target="_blank">http://help.yandex.ru/webmaster/?id=1113400</a>';

        //echo '<br><br>Если указано, что менее ста валидных объявлений, это не значит, ноль — это тоже меньше ста. Такое сообщение появляется автоматически и при отсутствии контента за последние пять дней.';
        echo '<br><br>Пытаться изменять дату создания на более новую — бессмысленно, поскольку сервис Яндекса запоминает первоначальную дату, с которой объявление попало на сервис.';
        Yii::app()->end();
    }

    private function clearByDate($preAd, $preKey)
    {
        ########################################################################
        # проверка на актуальность даты создания / обновления
        #
        #
        # https://yandex.ru/support/realty/rules/content-requirements.html
        # для продажи квартир на вторичке — созданные не более 90 дней назад, либо обновлённые не более 45 дней назад;
        # для длительной аренды квартир — созданные не более 7 дней назад, либо обновлённые не более 14 дней назад;
        # для продажи комнат — созданные не более 120 дней назад, либо обновлённые не более 45 дней назад;
        # для длительной аренды комнат — созданные не более 25 дней назад, либо обновлённые не более 24 дней назад;
        # для длительной аренды домов — созданные не более 30 дней назад, либо обновлённые не более 30 дней назад;

        if (isset($preAd['obj_type']) && $preAd['obj_type']['ya_subtype']) {
            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeApartment) && $preAd['type'] == \Apartment::TYPE_SALE &&
                (
                    strtotime($preAd['date_created']) < strtotime("-89 days") && strtotime($preAd['date_manual_updated']) < strtotime("-44 days")
                )
            ) {
                $this->errorByDate++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }

            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeApartment) && $preAd['type'] == \Apartment::TYPE_RENT && $preAd['price_type'] == \Apartment::PRICE_PER_MONTH &&
                (
                    strtotime($preAd['date_created']) < strtotime("-6 days") && strtotime($preAd['date_manual_updated']) < strtotime("-13 days")
                )
            ) {
                $this->errorByDate++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }

            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeRoom) && $preAd['type'] == \Apartment::TYPE_SALE &&
                (
                    strtotime($preAd['date_created']) < strtotime("-119 days") && strtotime($preAd['date_manual_updated']) < strtotime("-44 days")
                )
            ) {
                $this->errorByDate++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }

            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeRoom) && $preAd['type'] == \Apartment::TYPE_RENT && $preAd['price_type'] == \Apartment::PRICE_PER_MONTH &&
                (
                    strtotime($preAd['date_created']) < strtotime("-24 days") && strtotime($preAd['date_manual_updated']) < strtotime("-23 days")
                )
            ) {
                $this->errorByDate++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }

            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeHouse) && $preAd['type'] == \Apartment::TYPE_RENT && $preAd['price_type'] == \Apartment::PRICE_PER_MONTH &&
                (
                    strtotime($preAd['date_created']) < strtotime("-29 days") && strtotime($preAd['date_manual_updated']) < strtotime("-29 days")
                )
            ) {
                $this->errorByDate++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }

            if (in_array($preAd['obj_type']['ya_subtype'], self::$typeApartment) && !$preAd['num_of_rooms']) {
                $this->errorByRoom++;
                unset($this->adsWithoutDateCriteria[$preKey]);
                return;
            }
        }
    }

    public function getXml($listId = 0)
    {
        if($listId){
            $list = \YandexList::model()->findByPk($listId);

            if($list && ($criteria = $list->getCriteria())){
                $items = $this->getFeedItems($criteria);
            } else {
                return '';
            }
        } else {
            $items = $this->getFeedItems();
        }

        if(!$items){
            return '';
        }

        $lang = Yii::app()->language;

        $cacheKey = md5(json_encode([$items, $lang]));

        $resYandexRealtyXml = Yii::app()->cache->get($cacheKey);
        if ($resYandexRealtyXml !== false) {
            return $resYandexRealtyXml;
        }

        $xml = new \SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><realty-feed/>');
        $xml->addAttribute('xmlns', 'http://webmaster.yandex.ru/schemas/feed/realty/2010-06');
        $xml->addChild('generation-date', $this->generationDate);

        foreach ($items as $item) {
            if (isset($item['id'])) {
                $this->prepareItem($item, $xml);
            }
        }

        $res = $xml->asXML();

        if (param('cachingTime')){
            Yii::app()->cache->set($cacheKey, $res, param('cachingTime')); //60 * 60 *
        }

        return $res;
    }

    public function prepareItem($item = array(), $xml = null)
    {
        if (count($item) > 0 && $xml && array_key_exists('type', $item)) {
            /* type */
            if ($item['type'] == \Apartment::TYPE_RENT)
                $type = 'аренда';
            elseif ($item['type'] == \Apartment::TYPE_SALE)
                $type = 'продажа';
            else
                return;

            # Не указано количество комнат в квартире
//			if($item['obj_type_id'] == self::$typeApartment && !$item['num_of_rooms'])
//				return;
//
//			# только день, месяц для аренды
//			if ($item['type'] == \Apartment::TYPE_RENT) {
//				if ($item['price_type'] == \Apartment::PRICE_PER_HOUR || $item['price_type'] == \Apartment::PRICE_PER_WEEK)
//					return;
//			}

            $elem = $xml->addChild('offer');
            $elem->addAttribute('internal-id', $item['id']);
            $elem->addChild('type', $type);
            //  deb($item);

            switch ($item['obj_type']['ya_type']) {
                case \YandexRealty::YA_TYPE_LIVE:
                case \YandexRealty::YA_TYPE_NEW:
                    $elem->addChild('property-type', 'жилая');
                    /* category */
                    $elem->addChild('category', $item['obj_type']['ya_subtype']);
                    break;
                case \YandexRealty::YA_TYPE_COMM:
                    $elem->addChild('category', 'коммерческая');
                    $elem->addChild('commercial-type', $item['obj_type']['ya_subtype']);
                    break;
            }


            /* url */
            $url = (isset($item['seoUrl']) && $item['seoUrl']) ? Yii::app()->createAbsoluteUrl('/apartments/main/view', array('url' => $item['seoUrl'] . (param('urlExtension') ? '.html' : ''))) : Yii::app()->createAbsoluteUrl('/apartments/main/view', array('id' => $item['id']));
            $elem->addChild('url', $url);

            /* creation-date */
            $creationDate = date('c', strtotime($item['date_created']));
            $elem->addChild('creation-date', $creationDate);

            /* last-update-date */
            if (!empty($item['date_manual_updated']) && !is_null($item['date_manual_updated'])) {
                $updateDate = date('c', strtotime($item['date_manual_updated']));
                $elem->addChild('last-update-date', $updateDate);
            }

            /* manually-added */
            $elem->addChild('manually-added', 1);

            /* location */
            $location = $elem->addChild('location');
            if (issetModule('location')) {
                if ($item['loc_country_name'])
                    $location->addChild('country', $item['loc_country_name']);
                if ($item['loc_region_name'])
                    $location->addChild('region', $item['loc_region_name']);
                if ($item['loc_city_name'])
                    $location->addChild('locality-name', $item['loc_city_name']);
            } else {
                $location->addChild('country', $this->country);
                $location->addChild('region', $this->region);
                if ($item['city_name'])
                    $location->addChild('locality-name', $item['city_name']);
            }

            if ($item['address_' . Yii::app()->language])
                $location->addChild('address', $item['address_' . Yii::app()->language]);

            if (!empty($item['lat']) && !empty($item['lng'])) {
                $location->addChild('latitude', $item['lat']);
                $location->addChild('longitude', $item['lng']);
            }

            if (isset($item['metros']) && count($item['metros'])) {
                foreach ($item['metros'] as $metroName) {
                    $metro = $location->addChild('metro');
                    $metro->addChild('name', $metroName);
                }
            }

            /* sales info */
            $salesAgent = $elem->addChild('sales-agent');
            if ($item['owner_username'])
                $salesAgent->addChild('name', $item['owner_username']);

            if (!empty($item['phone'])) {
                $salesAgent->addChild('phone', $item['phone']);
            } elseif (!empty($item['owner_phone']))
                $salesAgent->addChild('phone', $item['owner_phone']);

            if ($item['owner_email'])
                $salesAgent->addChild('email', $item['owner_email']);

            if ($item['owner_type']) {
                if ($item['owner_type'] == \User::TYPE_PRIVATE_PERSON) {
                    $salesAgent->addChild('category', 'owner');
                } else {
                    $salesAgent->addChild('category', 'agency');
                    $salesAgent->addChild('agency-id', $item['owner_id']);
                }
            }

            /* price */
            $price = $elem->addChild('price');
            if ($item['type'] == \Apartment::TYPE_RENT) {
                if (issetModule('seasonalprices')) {
                    $price->addChild('value', $item['price_rent']);
                    $price->addChild('currency', $this->currency);
                    // только день, месяц
                    if ($item['price_type_rent'] == \Apartment::PRICE_PER_DAY)
                        $price->addChild('period', 'день');
                    if ($item['price_type_rent'] == \Apartment::PRICE_PER_MONTH)
                        $price->addChild('period', 'месяц');
                } else {
                    $price->addChild('value', $item['price']);
                    $price->addChild('currency', $this->currency);
                    if ($item['price_type'] == \Apartment::PRICE_PER_DAY)
                        $price->addChild('period', 'день');
                    if ($item['price_type'] == \Apartment::PRICE_PER_MONTH)
                        $price->addChild('period', 'месяц');
                }
            } else {
                $price->addChild('value', $item['price']);
                $price->addChild('currency', $this->currency);
            }

            /* images */
            if (isset($item['images']) && is_array($item['images'])) {
                foreach ($item['images'] as $value) {
                    if ($value['file_name_modified']) {
                        $imageUrl = Yii::app()->getBaseUrl(true) . '/uploads/objects/' . $item['id'] . '/modified/full_' . $value['file_name_modified'];
                        $elem->addChild('image', $imageUrl);
                    }
                }
            }

            /* description */
            if ($item['description_' . Yii::app()->language]) {
                $elem->addChild('description', strip_tags($item['description_' . Yii::app()->language]));
            }

            /* год постройки */
            if (isset($item['build_year']) && $item['build_year']) {
                $elem->addChild('built-year', (int)$item['build_year']);
            }

            /* area */
            if ($item['square'] || $item['land_square']) {
                // если участок
                if (in_array($item['obj_type']['ya_subtype'], self::$typeLand)) {
                    if ($item['land_square']) {
                        $lotArea = $elem->addChild('lot-area');
                        $lotArea->addChild('value', $item['land_square']);
                        $lotArea->addChild('unit', self::$landSquareUnit);
                    }
                } else { // комната, квартира, дом
                    if ($item['square']) {
                        $area = $elem->addChild('area');
                        $area->addChild('value', $item['square']);
                        $area->addChild('unit', self::$squareUnit);
                    }

                    if ($item['land_square']) {
                        $lotArea = $elem->addChild('lot-area');
                        $lotArea->addChild('value', $item['land_square']);
                        $lotArea->addChild('unit', self::$landSquareUnit);
                    }
                }
            }

            /* кол-во комнат */
            if (!empty($item['num_of_rooms'])) {
                $elem->addChild('rooms', $item['num_of_rooms']);
            }

            /* кол-во комнат в сделке  */
            if ($item['type'] == \Apartment::TYPE_RENT || $item['type'] == \Apartment::TYPE_SALE) {
                if ($item['obj_type_id'] == self::$typeRoom) {
                    if ($item['num_of_rooms'])
                        $elem->addChild('rooms-offered', $item['num_of_rooms']);
                    else
                        $elem->addChild('rooms-offered', 1);
                }
            }


            if (isset($item['reference'])) {

                /* наличие телефона */
                if (isset($item['reference'][29]))
                    $elem->addChild('phone', 1);

                /* наличие интернета */
                if (isset($item['reference'][30]))
                    $elem->addChild('internet', 1);

                /* наличие телевизора */
                if (isset($item['reference'][39]))
                    $elem->addChild('television', 1);

                /* наличие стиральной машины */
                if (isset($item['reference'][11]))
                    $elem->addChild('washing-machine', 1);

                /* наличие холодильника */
                if (isset($item['reference'][27]))
                    $elem->addChild('refrigerator', 1);

                /* коммуникации */
                /* электричество */
                if (isset($item['reference'][88]))
                    $elem->addChild('electricity-supply', 1);
                /* газ */
                if (isset($item['reference'][89]))
                    $elem->addChild('gas-supply', 1);
                /* вода */
                if (isset($item['reference'][90]))
                    $elem->addChild('water-supply', 1);
                /* канализация */
                if (isset($item['reference'][91]))
                    $elem->addChild('sewerage-supply', 1);

                /* кондиционер */
                if (isset($item['reference'][46]))
                    $elem->addChild('air-conditioner', 1);
                /* интернет */
                if (isset($item['internet'][47]))
                    $elem->addChild('air-conditioner', 1);
                /* с мебелью */
                if (isset($item['reference'][48]))
                    $elem->addChild('room-furniture', 1);
                /* мебель на кухне */
                if (isset($item['reference'][49]))
                    $elem->addChild('kitchen-furniture', 1);
                /* встроенная техника */
                if (isset($item['reference'][51]))
                    $elem->addChild('built-in-tech', 1);
            }

            /* свободная планировка */
            if (isset($item['open_plan']) && $item['open_plan'] == 52) {
                $elem->addChild('open-plan', 'да');
            }

            /* тип комнат */
            if (isset($item['room_type'])) {
                if ($item['room_type'] == 54)
                    $elem->addChild('rooms-type', 'раздельные');
                elseif ($item['room_type'] == 55)
                    $elem->addChild('rooms-type', 'смежные');
            }

            /* тип балкона */
            if (isset($item['balcony_type'])) {
                switch ($item['balcony_type']) {
                    case 56:
                        $elem->addChild('balcony', 'балкон');
                        break;
                    case 57:
                        $elem->addChild('balcony', 'лоджия');
                        break;
                    case 58:
                        $elem->addChild('balcony', '2 балкона');
                        break;
                    case 59:
                        $elem->addChild('balcony', '2 лоджии');
                        break;
                }
            }

            /* тип санузла */
            if (isset($item['wc_type'])) {
                if ($item['wc_type'] == 60)
                    $elem->addChild('bathroom-unit', 'совмещенный');
                elseif ($item['wc_type'] == 61)
                    $elem->addChild('bathroom-unit', 'раздельный');
                elseif ($item['wc_type'] == 62)
                    $elem->addChild('bathroom-unit', '2');
            }

            /* покрытие пола */
            if (isset($item['floor_coat'])) {
                switch ($item['floor_coat']) {
                    case 63:
                        $elem->addChild('floor-covering', 'ковролин');
                        break;
                    case 64:
                        $elem->addChild('floor-covering', 'ламинат');
                        break;
                    case 65:
                        $elem->addChild('floor-covering', 'линолеум');
                        break;
                    case 66:
                        $elem->addChild('floor-covering', 'паркет');
                        break;
                }
            }

            /* ремонт */
            if (isset($item['repair'])) {
                switch ($item['repair']) {
                    case 70:
                        $elem->addChild('renovation', 'дизайнерский');
                        break;
                    case 71:
                        $elem->addChild('renovationg', 'евро');
                        break;
                    case 72:
                        $elem->addChild('renovation', 'с отделкой');
                        break;
                    case 73:
                        $elem->addChild('renovation', 'требует ремонта');
                        break;
                    case 74:
                        $elem->addChild('renovation', 'хороший');
                        break;
                    case 75:
                        $elem->addChild('renovation', 'частичный ремонт');
                        break;
                    case 76:
                        $elem->addChild('renovation', 'черновая отделка');
                        break;
                }
            }

            /* состояние здания */
            if (isset($item['object_state'])) {
                switch ($item['object_state']) {
                    case 77:
                        $elem->addChild('quality', 'отличное');
                        break;
                    case 78:
                        $elem->addChild('quality', 'хорошее');
                        break;
                    case 79:
                        $elem->addChild('quality', 'нормальное');
                        break;
                    case 80:
                        $elem->addChild('quality', 'плохое');
                        break;
                }
            }

            /* !!!!!!!!!!!тип здания */ //ещё кирпично монолоиный!!!!!!!!!
            if (isset($item['building_type'])) {
                switch ($item['building_type']) {
                    case 81:
                        $elem->addChild('building-type', 'блочный');
                        break;
                    case 82:
                        $elem->addChild('building-type', 'деревянный');
                        break;
                    case 83:
                        $elem->addChild('building-type', 'кирпичный');
                        break;
                    case 84:
                        $elem->addChild('building-type', 'монолит');
                        break;
                    case 85:
                        $elem->addChild('building-type', 'панельный');
                        break;
                }
            }

            /* вид из окон */
            if ($item['window_to']) {
                $elem->addChild('window-view', $item['window_to_name']);
            }

            /* этаж */
            if (!empty($item['floor']))
                $elem->addChild('floor', $item['floor']);

            /* всего этажей */
            if (!empty($item['floor_total']))
                $elem->addChild('floors-total', $item['floor_total']);

            /* для аренды: можно ли с животными */
            if ($item['type'] == \Apartment::TYPE_RENT) {
                if (isset($item['reference']) && isset($item['reference'][42]))
                    $elem->addChild('with-pets', 0);
            }

            if (in_array($item['obj_type']['ya_subtype'], self::$typeGarage)) {
                /* тип гаража */
                if ($item['garage_type']) {
                    if ($item['garage_type'] == 67)
                        $elem->addChild('garage-type', 'гараж');
                    elseif ($item['garage_type'] == 68)
                        $elem->addChild('garage-type', 'машиноместо');
                    elseif ($item['garage_type'] == 69)
                        $elem->addChild('garage-type', 'бокс');
                }
            }

            if (in_array($item['obj_type']['ya_subtype'], self::$typeLand) || in_array($item['obj_type']['ya_subtype'], self::$typeHouse)) {
                /* тип земли */
                if (isset($item['plot_type'])) {
                    if ($item['plot_type'] == 86)
                        $elem->addChild('lot-type', 'ИЖС');
                    elseif ($item['plot_type'] == 87)
                        $elem->addChild('lot-type', 'садоводство');
                }
            }


            /* // если участок
              if ($item['obj_type_id'] == self::$typeLand) {
              //
              }
              else {  // комната, квартира, дом
              //
              } */
        }
        return;
    }


}