<?php

namespace application\modules\yandexRealty\services;


class YandexListService
{
    public function create(\YandexList $model)
    {
        $this->setData($model);

        return $model->save();
    }

    public function update(\YandexList $model)
    {
        $this->setData($model);

        return $model->save();
    }

    public function setAttributeSearch(\YandexList $model, \Apartment $apartment)
    {
        $search = $model->getFromJson('search');

        if($search){
            $apartment->attributes = $search;
        }
    }

    private function setData(\YandexList $model)
    {
        $model->attributes = $_POST['YandexList'] ?? [];

        if($model->itemsSelected){
            $model->setInJson('itemsSelected', $model->itemsSelected);
        }

        if(isset($_POST['Apartment'])){
            $model->setInJson('search', $_POST['Apartment']);
        } else {
            $model->setInJson('search', []);
        }
    }
}