<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */


class YandexRealtyImport extends Apartment
{
    # https://yandex.ru/support/realty/requirements/requirements-sale-housing.html
    # https://yandex.ru/support/realty/requirements/requirements-sale-new.html
    # https://yandex.ru/support/realty/requirements/requirements-commercial.html

    const API_URL = ''; # ссылка на xml фид
    const OWNER_ID = 1; # админ - владелец импортированных объектов

    const TMP_FILES_DIR = 'iecsv';
    const TIME_UPDATE = 86400; # обновляем фид один раз в сутки 

    private static $_objTypesByYandex = array();

    public function init()
    {
        $langs = Lang::getActiveLangs();
        if (empty($langs) || !isset($langs['ru'])) {
            YandexRealtyImport::writeLog(array('Нет языка RU. Дальнейшая работа невозможна: Яндекс.Недвижимость работает только по России.'));
            exit;
        }

        $yandexTypes = ApartmentObjType::getYANTypes(false);
        if (!empty($yandexTypes)) {
            foreach ($yandexTypes as $objType => $values) {
                $yandexCategoryNames = (isset($values['ya_subtype'])) ? explode(',', $values['ya_subtype']) : array();
                $yandexCategoryNames = array_map("trim", $yandexCategoryNames);

                if (!empty($yandexCategoryNames)) {
                    foreach ($yandexCategoryNames as $yandexTypeName) {
                        static::$_objTypesByYandex[$yandexTypeName] = $objType;
                    }
                }
            }
        } else {
            YandexRealtyImport::writeLog(array('Не заданы соответствия типов недвижимости'));
            exit;
        }
    }

    public function checkNeedUpdateData()
    {
        # скачиваем и храним xml для дальнейшей работы

        $data = Yii::app()->statePersister->load();

        if (isset($data['next_check_yandex_realty_import_data'])) {
            if ($data['next_check_yandex_realty_import_data'] < time()) {
                $data['next_check_yandex_realty_import_data'] = time() + self::TIME_UPDATE;
                Yii::app()->statePersister->save($data);

                return $this->updateDataFromRemoteFile();
            }
        } else {
            $data['next_check_yandex_realty_import_data'] = time() + self::TIME_UPDATE;
            Yii::app()->statePersister->save($data);

            return $this->updateDataFromRemoteFile();
        }

        return false;
    }

    public function updateDataFromRemoteFile()
    {
        $xmlData = getRemoteDataInfo(YandexRealtyImport::API_URL, false, 300);

        if (!empty($xmlData)) {
            $filePath = YandexRealtyImport::getXmlFilePath();

            if (file_put_contents($filePath['filePath'] . DIRECTORY_SEPARATOR . $filePath['fileName'], $xmlData, LOCK_EX)) {
                return true;
            } else {
                YandexRealtyImport::writeLog(array('Запись данных в файл не удалась', 'xmlData' => $xmlData));
            }
        } else {
            YandexRealtyImport::writeLog(array('Нет данных', 'xmlData' => $xmlData));
        }

        return false;
    }

    public function updateListings()
    {
        $xml = null;
        //$xmlData = YandexRealtyImport::getXmlFileData();
        $filePath = YandexRealtyImport::getXmlFilePath();


        if (file_exists($filePath['filePath'] . DIRECTORY_SEPARATOR . $filePath['fileName'])) {
            $xml = simplexml_load_file($filePath['filePath'] . DIRECTORY_SEPARATOR . $filePath['fileName']);
            $xml = (!empty($xml) && isset($xml->offer) && !empty($xml->offer)) ? $xml->offer : null;
        }

        if (!empty($xml)) {
            $objectsToDelete = $existsObjectsArr = $saveIds = $okXmlListingIds = array();

            # составим список всех объектов с systemStatus OK из xml файла
            foreach ($xml as $xmlListing) {
                $listingId = (isset($xmlListing['internal-id'])) ? (string)filter_var($xmlListing['internal-id'], FILTER_SANITIZE_STRING) : null;

                if (!empty($listingId)) {
                    $okXmlListingIds[$listingId] = $listingId;
                }
            }

            # все существующие объявления в нашей БД
            $sql = 'SELECT id, parse_internal_id FROM {{apartment}} WHERE parse_from = "yandexRealtyImport"';
            $existsObjectsArr = Yii::app()->db->createCommand($sql)->queryAll();
            if (!empty($existsObjectsArr)) {
                $existsObjectsArr = CHtml::listData($existsObjectsArr, 'parse_internal_id', 'id');
            }

            # составим список объектов из нашей БД, которых нет в фиде, для их последующего удаления
            if (!empty($okXmlListingIds)) {
                $objectsToDelete = array_diff_key($existsObjectsArr, $okXmlListingIds);
            } else { # нет ни одного объявления в фиде - удаляем все объекты
                $objectsToDelete = $existsObjectsArr;
            }

            # удалим неатуальные объекты
            if (!empty($objectsToDelete)) {
                foreach ($objectsToDelete as $listingId => $id) {
                    $apartment = Apartment::model()->findByPk($id);

                    if ($apartment) {
                        $apartment->delete();
                    }
                }
            }
            unset($objectsToDelete);

            # добавляем/обновляем объявления
            if (!empty($okXmlListingIds)) {
                $i = 0;
                foreach ($xml as $xmlListing) {
                    $listingId = (isset($xmlListing['internal-id'])) ? (string)filter_var($xmlListing['internal-id'], FILTER_SANITIZE_STRING) : null;

                    $resultSave = self::saveListingFromXml($xmlListing, $okXmlListingIds);

                    if ($resultSave === true) {
                        $saveIds[] = $listingId;
                    } else {
                        if ($resultSave !== null) {
                            $dataLog = array('Невозможно сохранить данные объявления', 'xmlListing' => $xmlListing, 'listingId' => $listingId, 'resultSave' => $resultSave);
                            if (is_object($resultSave) && is_a($resultSave, 'Apartment')) {
                                $modelErrors = $resultSave->getErrors();
                                if (!empty($modelErrors)) {
                                    array_push($dataLog, array('errors' => $modelErrors));
                                }
                            }

                            YandexRealtyImport::writeLog($dataLog);
                        }

                    }

                    $i++;
                }
            } else {
                YandexRealtyImport::writeLog(array('Нет объектов для добавления/обновления в xml', 'xml' => $xml, 'okXmlListingIds' => $okXmlListingIds));
            }
        } else {
            YandexRealtyImport::writeLog(array('Невозможно спарсить xml либо файл xml пуст', 'xml' => $xml, 'filePath' => $filePath));
        }
    }

    public static function saveListingFromXml($xmlListing, $okXmlListingIds = array())
    {
        if (!empty($xmlListing)) {
            $listingId = (isset($xmlListing['internal-id'])) ? (string)filter_var($xmlListing['internal-id'], FILTER_SANITIZE_STRING) : null;

            if ($listingId && isset($okXmlListingIds[$listingId])) {
                $isInsert = true;

                $sql = 'SELECT id FROM {{apartment}} WHERE parse_from = "yandexRealtyImport" AND parse_internal_id=:parse_internal_id';
                $apId = Yii::app()->db->createCommand($sql)->queryScalar(array(':parse_internal_id' => $listingId));
                if (!empty($apId)) {
                    $isInsert = false;
                }

                if ($isInsert) {
                    $model = new Apartment;
                } else {
                    $model = Apartment::model()->findByPk($apId);
                }

                if ($model) {
                    $activeLangs = Lang::getActiveLangs();

                    # тип сделки и тип недвижимости
                    $type = (isset($xmlListing->type)) ? (string)$xmlListing->type : 'продажа';
                    $type = ($type == 'продажа') ? Apartment::TYPE_SALE : Apartment::TYPE_RENT;

                    $propertyType = (isset($xmlListing->{'property-type'})) ? (string)$xmlListing->{'property-type'} : '';
                    $commercialType = (isset($xmlListing->{'commercial-type'})) ? (string)$xmlListing->{'commercial-type'} : '';
                    $category = (isset($xmlListing->category)) ? (string)$xmlListing->category : 'квартира';

                    // для коммерческой недвижимости тип недвижимости в параметре commercial-type, а для некоммерческой в параметре category
                    $xmlObjTypeName = (!empty($commercialType)) ? $commercialType : $category;

                    $objType = (isset(static::$_objTypesByYandex[$xmlObjTypeName]) && !empty(static::$_objTypesByYandex[$xmlObjTypeName])) ? static::$_objTypesByYandex[$xmlObjTypeName] : 0;

                    if (empty($objType)) { // импортируемого типа недвижимости нет в базе сайта
                        unset($model);
                        return null;
                    }

                    /*if ($objType == 11) { # Проверим, а не в новостройке ли квартира
                        $buildingState = (isset($xmlListing->{'building-state'})) ? (string) $xmlListing->{'building-state'} : null;
                        if (!empty($buildingState)) {
                            $objType = 10; # Квартира в новостройке
                        }
                    }*/

                    $model->type = $type;
                    $model->obj_type_id = $objType;

                    if ($isInsert) {
                        # date_created
                        $model->date_created = new CDbExpression('NOW');

                        # date_end_activity , activity_always
                        $model->activity_always = 1;
                        //$model->date_end_activity = new CDbExpression('NULL');
                    } else {
                        $model->date_updated = new CDbExpression('NOW');
                    }

                    # цена
                    $price = (isset($xmlListing->price) && isset($xmlListing->price->value)) ? (float)$xmlListing->price->value : 0;
                    $currency = (isset($xmlListing->price) && isset($xmlListing->price->currency)) ? (string)$xmlListing->price->currency : '';

                    if (issetModule('currency')) {
                        if ($currency == 'RUR') {
                            $currency = 'RUB';
                        }
                        $model->in_currency = $currency;

                        // конвертация не нужна, т.к. есть в Apartment::afterSave при отличии in_currency от дефолтной
                        // $price = (int)Currency::convert($price, $model->in_currency, $defaultCurrencyCharCode);
                    }

                    if ($price) {
                        $model->is_price_poa = 0;
                        $model->price = $price;
                    } else {
                        $model->is_price_poa = 1;
                        $model->price = 0;
                    }


                    # тип цены
                    $pricePeriod = (isset($xmlListing->price) && isset($xmlListing->price->period)) ? (string)$xmlListing->price->period : '';

                    $priceType = Apartment::PRICE_SALE;
                    if (!empty($pricePeriod) && $model->type == Apartment::TYPE_RENT) {
                        switch ($pricePeriod) {
                            case 'день':
                            case 'day':
                                $priceType = Apartment::PRICE_PER_DAY;
                                break;
                            case 'месяц':
                            case 'month':
                                $priceType = Apartment::PRICE_PER_MONTH;
                                break;
                        }
                    }
                    $model->price_type = $priceType;

                    # описание
                    $description = (isset($xmlListing->description)) ? (string)$xmlListing->description : '';

                    if (!empty($description)) {
                        $model->description_ru = $description;

                        if (is_array($activeLangs) && !empty($activeLangs)) {
                            foreach ($activeLangs as $lang) {
                                $model->setAttribute('description_' . $lang, $description);
                            }
                        }
                    }

                    // если объявление уже существует, то обновляем поля: цена и описание
                    if (empty($isInsert)) {
                        if (issetModule('seasonalprices') && $model->type == Apartment::TYPE_RENT) {
                            $sql = 'UPDATE {{seasonal_prices}} SET price=:price, price_type=:price_type WHERE apartment_id=:apartment_id LIMIT 1';
                            Yii::app()->db->createCommand($sql)->execute(array(':price' => $model->price, ':price_type' => $model->price_type, ':apartment_id' => $model->id));
                        }

                        return $model->save(false);
                    }

                    # общее
                    $model->loc_country = $model->loc_region = $model->loc_city = $model->city_id = 0;
                    $model->owner_id = self::OWNER_ID; # админ-владелец
                    $model->owner_active = $model->active = Apartment::STATUS_ACTIVE;

                    $model->parse_from = 'yandexRealtyImport';
                    $model->parse_internal_id = $listingId;
                    $model->parse_internal_url = (isset($xmlListing->url)) ? (string)$xmlListing->url : '';

                    # информация о пользователе
                    $model->parse_owner_info_user_type = User::TYPE_PRIVATE_PERSON;
                    $userCategory = (isset($xmlListing->{'sales-agent'}) && isset($xmlListing->{'sales-agent'}->category)) ? (string)$xmlListing->{'sales-agent'}->category : '';
                    if ($userCategory == 'агентство' || $userCategory == 'agency') {
                        $model->parse_owner_info_user_type = User::TYPE_AGENCY;
                    }

                    $model->phone = $model->parse_owner_info_phone = (isset($xmlListing->{'sales-agent'}) && isset($xmlListing->{'sales-agent'}->phone)) ? (string)$xmlListing->{'sales-agent'}->phone : '';
                    $model->parse_owner_info_name = (isset($xmlListing->{'sales-agent'}) && isset($xmlListing->{'sales-agent'}->name)) ? (string)$xmlListing->{'sales-agent'}->name : '';
                    if (empty($model->parse_owner_info_name)) {
                        $model->parse_owner_info_name = (isset($xmlListing->{'sales-agent'}) && isset($xmlListing->{'sales-agent'}->organization)) ? (string)$xmlListing->{'sales-agent'}->organization : '';
                    }
                    if (empty($model->parse_owner_info_name)) {
                        $model->parse_owner_info_name = 'Гость';
                    }

                    // адрес
                    $fullAddressArr = array();
                    $fullAddressArr[] = $countryName = (isset($xmlListing->location) && isset($xmlListing->location->country)) ? (string)trim($xmlListing->location->country) : '';
                    $fullAddressArr[] = $regionName = (isset($xmlListing->location) && isset($xmlListing->location->region)) ? (string)trim(str_replace("обл.", "область", $xmlListing->location->region)) : '';
                    $fullAddressArr[] = $cityName = (isset($xmlListing->location) && isset($xmlListing->location->{'locality-name'})) ? (string)trim(str_replace(array('п.', 'рп.', 'д.'), '', $xmlListing->location->{'locality-name'})) : '';
                    $districtName = (isset($xmlListing->location) && isset($xmlListing->location->{'sub-locality-name'})) ? (string)trim($xmlListing->location->{'sub-locality-name'}) : '';
                    $fullAddressArr[] = $addressName = (isset($xmlListing->location) && isset($xmlListing->location->address)) ? (string)trim($xmlListing->location->address) : '';
                    $fullAddressArr = array_filter($fullAddressArr);

                    if (issetModule('location')) {
                        if ($countryName) {
                            $countryInfo = Country::model()->findByAttributes(array('name_ru' => mb_strtolower($countryName, 'UTF-8')));

                            if ($countryInfo) {
                                $model->loc_country = $countryInfo->id;
                            } else {
                                $newCountryModel = new Country;
                                $newCountryModel->active = 1;
                                $newCountryModel->name_ru = $countryName;

                                if (is_array($activeLangs) && !empty($activeLangs)) {
                                    foreach ($activeLangs as $lang) {
                                        $newCountryModel->setAttribute('name_' . $lang, $countryName);
                                    }
                                }

                                $newCountryModel->save(false);

                                if ($newCountryModel && $newCountryModel->id) {
                                    $model->loc_country = $newCountryModel->id;
                                }
                            }
                        }

                        if ($regionName) {
                            $regionInfo = Region::model()->findByAttributes(array('name_ru' => mb_strtolower($regionName, 'UTF-8'), 'country_id' => $model->loc_country));

                            if ($regionInfo) {
                                $model->loc_region = $regionInfo->id;
                            } else {
                                $newRegionModel = new Region;
                                $newRegionModel->country_id = $model->loc_country;
                                $newRegionModel->active = 1;
                                $newRegionModel->name_ru = $regionName;

                                if (is_array($activeLangs) && !empty($activeLangs)) {
                                    foreach ($activeLangs as $lang) {
                                        $newRegionModel->setAttribute('name_' . $lang, $regionName);
                                    }
                                }

                                $newRegionModel->save(false);

                                if ($newRegionModel && $newRegionModel->id) {
                                    $model->loc_region = $newRegionModel->id;
                                }
                            }
                        }

                        if ($cityName) {
                            $cityInfo = null;

                            if ($model->loc_region) {
                                $cityInfo = City::model()->findByAttributes(array('name_ru' => mb_strtolower($cityName, 'UTF-8'), 'region_id' => $model->loc_region));
                            } else {
                                $cityInfo = City::model()->findByAttributes(array('name_ru' => mb_strtolower($cityName, 'UTF-8'), 'country_id' => $model->loc_country));
                            }

                            if ($cityInfo) {
                                $model->loc_city = $cityInfo->id;
                                if (!$model->loc_region) {
                                    $model->loc_region = $cityInfo->region_id;
                                }
                            } else {
                                $newCityModel = new City;
                                $newCityModel->country_id = $model->loc_country;
                                $newCityModel->region_id = $model->loc_region;
                                $newCityModel->active = 1;
                                $newCityModel->name_ru = $cityName;

                                if (is_array($activeLangs) && !empty($activeLangs)) {
                                    foreach ($activeLangs as $lang) {
                                        $newCityModel->setAttribute('name_' . $lang, $cityName);
                                    }
                                }

                                $newCityModel->save(false);

                                if ($newCityModel && $newCityModel->id) {
                                    $model->loc_city = $newCityModel->id;
                                }
                            }
                        }
                    } else {
                        if ($cityName) {
                            $cityInfo = ApartmentCity::model()->findByAttributes(array('name_ru' => mb_strtolower($cityName, 'UTF-8')));

                            if ($cityInfo) {
                                $model->city_id = $cityInfo->id;
                            } else {
                                $newCityModel = new ApartmentCity;
                                $newCityModel->active = 1;
                                $newCityModel->name_ru = $cityName;

                                if (is_array($activeLangs) && !empty($activeLangs)) {
                                    foreach ($activeLangs as $lang) {
                                        $newCityModel->setAttribute('name_' . $lang, $cityName);
                                    }
                                }

                                $newCityModel->save(false);

                                if ($newCityModel && $newCityModel->id) {
                                    $model->city_id = $newCityModel->id;
                                }
                            }
                        }
                    }

                    # метро
                    if (issetModule('metroStations')) {
                        $metrosArr = array();
                        $metros = (isset($xmlListing->location) && isset($xmlListing->location->metro)) ? $xmlListing->location->metro : null;
                        if (!empty($metros)) {
                            foreach ($metros as $element) {
                                $metroName = (isset($element->name)) ? (string)filter_var($element->name, FILTER_SANITIZE_STRING) : '';
                                $timeTransport = (isset($element->{'time-on-transport'})) ? (int)$element->{'time-on-transport'} : '';
                                $timeFoot = (isset($element->{'time-on-foot'})) ? (int)$element->{'time-on-foot'} : '';

                                $metrosArr[] = array(
                                    'name' => $metroName,
                                    'time_on_transport' => $timeTransport,
                                    'time_on_foot' => $timeFoot,
                                );
                            }
                        }
                    }

                    # площадь
                    $sumArea = (isset($xmlListing->area) && isset($xmlListing->area->value)) ? (float)$xmlListing->area->value : 0;
                    $model->square = $model->land_square = $sumArea;

                    $landArea = (isset($xmlListing->{'lot-area'}) && isset($xmlListing->{'lot-area'}->value)) ? (float)$xmlListing->{'lot-area'}->value : null;
                    if ($landArea !== null) {
                        $model->land_square = $landArea;
                    }

                    # кол-во комнат
                    $model->num_of_rooms = (isset($xmlListing->rooms)) ? (int)$xmlListing->rooms : 0;

                    # этаж, всего этажей
                    $model->floor = (isset($xmlListing->floor)) ? (int)$xmlListing->floor : 0;
                    $model->floor_total = (isset($xmlListing->{'floors-total'})) ? (int)$xmlListing->{'floors-total'} : 0;

                    # адрес
                    $address = (isset($xmlListing->location) && isset($xmlListing->location->address)) ? (string)trim($xmlListing->location->address) : '';
                    // адреса нет в фиде - в адресе будет населённый пункт
                    if (empty($address)) {
                        if (!empty($cityName)) {
                            $address = $cityName;
                        }
                    }
                    if (!empty($address)) {
                        $model->address_ru = $address;

                        if (is_array($activeLangs) && !empty($activeLangs)) {
                            foreach ($activeLangs as $lang) {
                                $model->setAttribute('address_' . $lang, $address);
                            }
                        }
                    }

                    # координаты
                    $model->lat = (isset($xmlListing->location) && isset($xmlListing->location->latitude)) ? (float)$xmlListing->location->latitude : 0;
                    $model->lng = (isset($xmlListing->location) && isset($xmlListing->location->longitude)) ? (float)$xmlListing->location->longitude : 0;

                    # если в фиде нет координат, то получим их исходя из адреса объекта
                    if (empty($model->lat) || empty($model->lng)) {
                        if (!empty($fullAddressArr)) {
                            $fullAddress = implode(', ', $fullAddressArr);

                            $resultGeocoding = Geocoding::getCoordsByAddress($fullAddress);
                            if (!empty($resultGeocoding) && (isset($resultGeocoding['lat'])) && isset($resultGeocoding['lng'])) {
                                $model->lat = (float)$resultGeocoding['lat'];
                                $model->lng = (float)$resultGeocoding['lng'];
                            }
                        }
                    }


                    # окна выходят на
                    $windowS = (isset($xmlListing->{'window-view'})) ? (string)$xmlListing->{'window-view'} : 0;
                    if (!empty($windowS)) {
                        $windowTo = 0;
                        switch ($windowS) {
                            case 'во двор':
                                $windowTo = 2;
                                break;
                            case 'на улицу':
                                $windowTo = 1;
                                break;
                        }

                        $model->window_to = $windowTo;
                    }


                    # генерируем заголовок
                    $model->generateSeoTitles();

                    if (!$model->save()) {
                        return $model;
                    } else {
                        // станции метро
                        if (issetModule('metroStations')) {
                            if (!empty($metrosArr)) {
                                foreach ($metrosArr as $key => $metro) {
                                    $metroInfo = null;

                                    if ($model->loc_city) {
                                        $metroInfo = MetroStations::model()->findByAttributes(array('name_ru' => mb_strtolower($metro['name'], 'UTF-8'), 'loc_city' => $model->loc_city));
                                    } else {
                                        $metroInfo = MetroStations::model()->findByAttributes(array('name_ru' => mb_strtolower($metro['name'], 'UTF-8'), 'city_id' => $model->city_id));
                                    }

                                    if ($metroInfo) {
                                        $metrosArr[$key]['id'] = $metroInfo->id;
                                    } else {
                                        $newMetroModel = new MetroStations;
                                        $newMetroModel->loc_city = $model->loc_city;
                                        $newMetroModel->city_id = $model->city_id;
                                        $newMetroModel->active = 1;
                                        $newMetroModel->name_ru = $metro['name'];

                                        if (is_array($activeLangs) && !empty($activeLangs)) {
                                            foreach ($activeLangs as $lang) {
                                                $newMetroModel->setAttribute('name_' . $lang, $metro['name']);
                                            }
                                        }

                                        $newMetroModel->save(false);

                                        if ($newMetroModel && $newMetroModel->id) {
                                            $metrosArr[$key]['id'] = $newMetroModel->id;
                                        }
                                    }
                                }

                                // добавляем к объявлению
                                foreach ($metrosArr as $metro) {
                                    $apartmentMetro = new ApartmentMetroStations;
                                    $apartmentMetro->apartment_id = $model->id;
                                    $apartmentMetro->metro_id = $metro['id'];
                                    $apartmentMetro->time_on_transport = $metro['time_on_transport'];
                                    $apartmentMetro->time_on_foot = $metro['time_on_foot'];
                                    $apartmentMetro->date_updated = date(HSite::$dateFormat);
                                    $apartmentMetro->save(false);
                                }
                            }
                        }

                        // сезонные цены
                        if (issetModule('seasonalprices') && $model->type == Apartment::TYPE_RENT) {
                            $seasonalPriceModel = new Seasonalprices();
                            if (is_array($activeLangs) && !empty($activeLangs)) {
                                foreach ($activeLangs as $lang) {
                                    $seasonalPriceModel->setAttribute('name_' . $lang, '---');
                                }
                            }
                            $seasonalPriceModel->price = $model->price;
                            $seasonalPriceModel->price_type = $model->price_type;
                            $seasonalPriceModel->date_start = 1;
                            $seasonalPriceModel->month_start = 1;
                            $seasonalPriceModel->date_end = 31;
                            $seasonalPriceModel->month_end = 12;
                            $seasonalPriceModel->sorter = 1;
                            $seasonalPriceModel->apartment_id = $model->id;
                            $seasonalPriceModel->save(false);
                        }

                        # изображения
                        // удаляем старые
                        Images::deleteByObjectId($model);

                        // загружаем новые фотографии, если есть
                        $images = (isset($xmlListing->image) && !empty($xmlListing->image)) ? $xmlListing->image : null;
                        if (!empty($images)) {
                            $path = Yii::getPathOfAlias('webroot.uploads.objects') . DIRECTORY_SEPARATOR . $model->id . DIRECTORY_SEPARATOR . Images::ORIGINAL_IMG_DIR;
                            $pathMod = Yii::getPathOfAlias('webroot.uploads.objects') . DIRECTORY_SEPARATOR . $model->id . DIRECTORY_SEPARATOR . Images::MODIFIED_IMG_DIR;

                            $oldUMask = umask(0);
                            if (!is_dir($path)) {
                                @mkdir($path, 0777, true);
                            }
                            if (!is_dir($pathMod)) {
                                @mkdir($pathMod, 0777, true);
                            }
                            umask($oldUMask);

                            if (is_writable($path) && is_writable($pathMod)) {
                                touch($path . DIRECTORY_SEPARATOR . 'index.htm');
                                touch($pathMod . DIRECTORY_SEPARATOR . 'index.htm');

                                $downloadedImages = array();
                                $cntSuccessAddingImages = 0;
                                $tmpFilesPath = Yii::getPathOfAlias('webroot.uploads') . DIRECTORY_SEPARATOR . self::TMP_FILES_DIR . DIRECTORY_SEPARATOR . 'images';

                                $i = 1;
                                foreach ($images as $image) {
                                    $image = (string)$image;

                                    #sleep(mt_rand(1, 2));
                                    usleep(mt_rand(100, 200));
                                    $imageContent = getRemoteDataInfo($image, false, 20);

                                    if ($imageContent) {
                                        $imageName = substr($image, strrpos($image, '/') + 1);

                                        $photoPath = $tmpFilesPath . DIRECTORY_SEPARATOR . $imageName;
                                        if (file_put_contents($photoPath, $imageContent)) {
                                            if (file_exists($photoPath) && filesize($photoPath) > 10000) { # 10 kb                                                
                                                $downloadedImages[$i]['name'] = $imageName;
                                            } else {
                                                @unlink($photoPath);
                                            }
                                        }
                                    }
                                    $i++;
                                }

                                if (count($downloadedImages)) {
                                    foreach ($downloadedImages as $item) {
                                        if (file_exists($tmpFilesPath . DIRECTORY_SEPARATOR . $item['name'])) {
                                            if (copy($tmpFilesPath . DIRECTORY_SEPARATOR . $item['name'], $path . DIRECTORY_SEPARATOR . $item['name'])) {
                                                @unlink($tmpFilesPath . DIRECTORY_SEPARATOR . $item['name']);

                                                $image = new Images();
                                                $image->id_object = $model->id;
                                                $image->id_owner = $model->owner_id;
                                                $image->file_name = $item['name'];

                                                if (!$image->save()) {
                                                    YandexRealtyImport::writeLog(array('Изображение не было загружено для объекта', 'model_id' => $model->id, 'Error' => $image->getErrors()));
                                                } else {
                                                    $cntSuccessAddingImages++;
                                                }
                                            }
                                        }
                                    }
                                }
                            }

                            if ($cntSuccessAddingImages > 0) {
                                $model->count_img = $cntSuccessAddingImages;
                                $model->update(array('count_img'));
                            }
                        }

                        /*
                        # справочники
                        // удаляем старые
                        $sql = 'DELETE FROM {{apartment_reference}} WHERE apartment_id="' . $model->id . '"';
                        Yii::app()->db->createCommand($sql)->execute();
                                                                            
                        // заполним стандартными ключами 0-10
                        $referencesArr = array_fill(0, 10, array());
                                                
                        // раздельный санузел
                        $bathroomUnit = (isset($xmlListing->{'bathroom-unit'})) ? (string) $xmlListing->{'bathroom-unit'} : 0;
                        if ($bathroomUnit == 'раздельный' || $bathroomUnit == 2) {
                            $referencesArr[2] = CMap::mergeArray($referencesArr[2], array(10 => true));
                        }
                                               
                        // Телевизор
                        $isTelevision = (isset($xmlListing->television)) ? (string) $xmlListing->television : false;
                        if ($isTelevision == 'да' || $isTelevision == 'true' || $isTelevision == 1 || $isTelevision == '+' || $isTelevision == true) {
                            $referencesArr[7] = CMap::mergeArray($referencesArr[7], array(39 => true));
                        }
                        
                        // Телефон
                        $isTelephone = (isset($xmlListing->phone)) ? (string) $xmlListing->phone : false;
                        if ($isTelephone == 'да' || $isTelephone == 'true' || $isTelephone == 1 || $isTelephone == '+' || $isTelephone == true) {
                            $referencesArr[4] = CMap::mergeArray($referencesArr[4], array(29 => true));
                        }
                        
                        // Холодильник
                        $isRefr = (isset($xmlListing->refrigerator)) ? (string) $xmlListing->refrigerator : false;
                        if ($isRefr == 'да' || $isRefr == 'true' || $isRefr == 1 || $isRefr == '+' || $isRefr == true) {
                            $referencesArr[3] = CMap::mergeArray($referencesArr[3], array(27 => true));
                        }
                        
                        // Стиральная машина
                        $isWashingMachine = (isset($xmlListing->{'washing-machine'})) ? (string) $xmlListing->{'washing-machine'} : false;
                        if ($isWashingMachine == 'да' || $isWashingMachine == 'true' || $isWashingMachine == 1 || $isWashingMachine == '+' || $isWashingMachine == true) {
                            $referencesArr[2] = CMap::mergeArray($referencesArr[2], array(11 => true));
                        }
                        
                        // очистим пустые элементы массива
                        $referencesArr = array_filter($referencesArr);
                                                
                        if (!empty($referencesArr)) {
                            foreach ($referencesArr as $catId => $value) {
                                if (is_array($value) && !empty($value)) {
                                    foreach ($value as $valId => $val) {
                                        if ($val) {
                                            $sql = 'INSERT INTO {{apartment_reference}} (reference_id, reference_value_id, apartment_id)
                                                VALUES (:refId, :refValId, :apId) ';
                                            $command = Yii::app()->db->createCommand($sql);
                                            $command->bindValue(":refId", $catId, PDO::PARAM_INT);
                                            $command->bindValue(":refValId", $valId, PDO::PARAM_INT);
                                            $command->bindValue(":apId", $model->id, PDO::PARAM_INT);
                                            $command->execute();
                                        }
                                    }
                                }
                            }
                        }
                        */

                        return true;
                    }
                }
            }
        }

        return false;
    }

    public static function getXmlFilePath()
    {
        $return = array(
            'fileName' => 'yandexrealtydata.xml', # 'yandexrealtydata_' . date('Y-m-d__H-i-s') . '.xml';
            'filePath' => Yii::getPathOfAlias('webroot.uploads') . DIRECTORY_SEPARATOR . self::TMP_FILES_DIR
        );

        return $return;
    }

    public static function getXmlFileData()
    {
        $fileData = YandexRealtyImport::getXmlFilePath();

        if (file_exists($fileData['filePath'] . DIRECTORY_SEPARATOR . $fileData['fileName'])) {
            return file_get_contents($fileData['filePath'] . DIRECTORY_SEPARATOR . $fileData['fileName']);
        }

        return false; # файла нет
    }

    public static function writeLog($mVal)
    {
        $file = Yii::getPathOfAlias('webroot.uploads') . DIRECTORY_SEPARATOR . self::TMP_FILES_DIR . DIRECTORY_SEPARATOR . 'yandex_realty_debug_logs.txt';

        //$sLogs = date("Y-m-d H:i:s: ") . var_export($mVal, true) . "\r\n";
        $sLogs = date("Y-m-d H:i:s: ") . print_r($mVal, true) . "\r\n";
        $sLogs .= str_repeat('=', 15) . "\r\n";

        file_put_contents($file, $sLogs, FILE_APPEND | LOCK_EX);
    }

    public function deleteOldTmpFiles()
    {
        $excludeFiles = array('.empty', 'index.htm');

        $dir = Yii::getPathOfAlias('webroot.uploads') . DIRECTORY_SEPARATOR . self::TMP_FILES_DIR . DIRECTORY_SEPARATOR . 'images';

        $this->customrrmdir($dir, $excludeFiles);
    }

    public function customrrmdir($dir, $excludeFiles = array(), $excludeDirs = array(), $depth = 0)
    {
        if (is_dir($dir)) {
            $objects = scandir($dir);
            if ($objects) {
                foreach ($objects as $object) {
                    if ($object != "." && $object != ".." && !in_array($object, $excludeFiles)) {
                        if (filetype($dir . DIRECTORY_SEPARATOR . $object) == "dir") {
                            $depth = $depth + 1;
                            $this->customrrmdir($dir . DIRECTORY_SEPARATOR . $object, $excludeFiles, $excludeDirs, $depth);
                        } else {
                            $timeUpdated = filemtime($dir . DIRECTORY_SEPARATOR . $object);

                            if ($timeUpdated < time() - 86400) { # файл старше 1 дня
                                @unlink($dir . DIRECTORY_SEPARATOR . $object);
                            }
                        }
                    }
                }
            }

            reset($objects);

            if (!in_array(substr($dir, strrpos($dir, '/') + 1), $excludeDirs) && $depth) {
                $timeUpdated = filemtime($dir);

                if ($timeUpdated < time() - 86400) { # файл старше 1 дня
                    @rmdir($dir);
                }
            }
        }
    }

    public static function strposArr($haystack, $needle, $offset = 0)
    {
        if (!is_array($needle)) $needle = array($needle);
        foreach ($needle as $key => $query) {
            if (strpos($haystack, $query, $offset) !== false) return array('key' => $key, 'query' => $query); // stop on first true result
        }
        return false;
    }
}
