<?php

/**
 * This is the model class for table "{{yandex_list}}".
 *
 * The followings are the available columns in table '{{yandex_list}}':
 * @property integer $id
 * @property integer $status
 * @property integer $count_ap
 * @property string $name
 * @property string $url
 * @property string $date_created
 * @property string $date_updated
 * @property string $data_json
 *
 * @mixin JsonBehavior
 */
class YandexList extends CActiveRecord
{
    public $itemsSelected;

    public function behaviors()
    {
        $arr = [];
        $arr['AutoTimestampBehavior'] = array(
            'class' => 'zii.behaviors.CTimestampBehavior',
            'createAttribute' => 'date_created',
            'updateAttribute' => 'date_updated',
        );
        $arr['JsonBehavior'] = array(
            'class' => 'application.components.behaviors.JsonBehavior',
        );
        return $arr;
    }

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{yandex_list}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name', 'required'),
			array('status, count_ap', 'numerical', 'integerOnly'=>true),
			array('name, url', 'length', 'max'=>255),
			array('data_json, itemsSelected', 'safe'),
			array('id, status, name, url, date_created, date_updated', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'status' => 'Status',
			'name' => tc('Name'),
			'url' => 'Url',
			'date_created' => 'Date Created',
			'date_updated' => 'Date Updated',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('status',$this->status);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('date_created',$this->date_created,true);
		$criteria->compare('date_updated',$this->date_updated,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return YandexList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

    public function getUrl()
    {
        return Yii::app()->createAbsoluteUrl('/yandexRealty/main/feed', ['id' => $this->id]);
	}

    public function getCriteria()
    {
        $model = new Apartment();

        $search = $this->getFromJson('search');
        if($search) {
            $model->attributes = $search;
        }

        $dataProvider = $model->searchExport();

        return $dataProvider->criteria;
	}
}
