<?php

class MainController extends ModuleAdminController
{
    public $modelName = 'YandexList';

    public function accessRules()
    {
        return array(
            array('allow',
                'expression' => "Yii::app()->user->checkAccess('users_admin')",
            ),
            array('deny',
                'users' => array('*'),
            ),
        );
    }

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
	    $model = $this->loadModel($id);

        $this->redirect($model->getUrl());

		$this->render('view',array(
			'model' => $model,
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new YandexList;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['YandexList']))
		{
		    $service = new \application\modules\yandexRealty\services\YandexListService();

			if($service->create($model)){
                Yii::app()->user->setFlash('success', tc('Success'));
                //$this->redirect(array('admin'));
            }
		}

        $modelAps = new Apartment('searchExport');
        $modelAps->resetScope();
        $modelAps->scenario = 'search';

        $modelAps->unsetAttributes();  // clear any default values
        if (isset($_GET[$this->modelName])) {
            $modelAps->attributes = $_GET[$this->modelName];
        }

		$this->render('create',array(
			'model'=>$model,
			'modelAps'=>$modelAps,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
        $service = new \application\modules\yandexRealty\services\YandexListService();

        $model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

        $modelAps = new Apartment('searchExport');
        $modelAps->resetScope();
        $modelAps->scenario = 'search';

        $modelAps->unsetAttributes();  // clear any default values
        if (isset($_GET[$this->modelName])) {
            $modelAps->attributes = $_GET['Apartment'];
        }

        $service->setAttributeSearch($model, $modelAps);

		if(isset($_POST['YandexList']))
		{
			if($service->update($model)){
			    Yii::app()->user->setFlash('success', tc('Success'));
			    $this->refresh();
                //$this->redirect(array('admin'));
            }
		}

        if($model->itemsSelected){
            $_GET['Apartment_sel'] = explode(',', $model->itemsSelected);
        }

		$this->render('update', array(
			'model'=>$model,
			'modelAps'=>$modelAps,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('YandexList');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new YandexList('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['YandexList']))
			$model->attributes=$_GET['YandexList'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}
}
