<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class MainController extends ModuleUserController
{
    public function actionFeed($id)
    {
        $this->actionViewFeed($id);
    }

    public function actionViewFeed($id = 0)
    {
        $oldLang = Yii::app()->language;

        Controller::disableProfiler();

        $defaultLangs = Lang::getDefaultLang();
        Yii::app()->language = $defaultLangs;

        // если есть русский или украинский языки, но они не дефолтные. установим на время их.
        if ($defaultLangs != 'ru' || $defaultLangs != 'uk') {
            $allLangs = Lang::getActiveLangs();

            if (array_key_exists('ru', $allLangs))
                Yii::app()->language = 'ru';
            elseif (array_key_exists('uk', $allLangs))
                Yii::app()->language = 'uk';
        }

        $xml = (new \application\modules\yandexRealty\services\YandexRealtyService())->getXml($id);

        if ($xml) {
            header('Content-type: text/xml');
            header('Pragma: public');
            header('Cache-control: private');
            header('Expires: -1');

            echo $xml;

            Yii::app()->end();
        } else {
            echo 'no elements';
        }

        // установим обратно пользовательский язык
        Yii::app()->language = $oldLang;
    }

}
