<?php
$this->pageTitle = Yii::app()->name . ' - ' . tt('Manage tariff plans', 'tariffPlans');

$this->menu = array(
    AdminLteHelper::getAddMenuLink(tt('Add tariff plan'), array('create')),
);

$this->adminTitle = tt('Manage tariff plans', 'tariffPlans');

echo '<h3>' . tt('Paid tariff plans', 'tariffPlans') . '</h3>';

$this->widget('CustomGridView', array(
    'allowNoMoreTables' => true,
    'id' => 'paid-tariff-plans-grid',
    'dataProvider' => $paidModels->search(),
    'filter' => $paidModels,
    'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); attachStickyTableHeader();}',
    'columns' => array(
        array(
            'name' => 'active',
            'type' => 'raw',
            'value' => 'Yii::app()->controller->returnStatusHtml($data, "paid-tariff-plans-grid", 1, TariffPlans::DEFAULT_TARIFF_PLAN_ID)',
            'htmlOptions' => array(
                'class' => 'infopages_status_column',
                'data-title' => tc('Status'),
            ),
            'filter' => false,
            'sortable' => false,
            //'visible' => '$data->id != TariffPlans::DEFAULT_TARIFF_PLAN_ID',
        ),
        array(
            'name' => 'for_user_type_id',
            'value' => 'User::getTypeList(null, $data->for_user_type_id)',
            'filter' => User::getTypeList(),
            'htmlOptions' => array(
                'data-title' => tt('For user type', 'tariffPlans'),
            ),
            'sortable' => false,
        ),
        array(
            'name' => 'name',
            'htmlOptions' => array(
                'data-title' => tt('Name', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'show_address',
            'value' => '($data->show_address) ? tc("Yes") : tc("No")',
            'sortable' => false,
            'filter' => array(0 => tc('No'), 1 => tc('Yes')),
            'htmlOptions' => array(
                'data-title' => tt('Show_address', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'show_phones',
            'value' => '($data->show_phones) ? tc("Yes") : tc("No")',
            'sortable' => false,
            'filter' => array(0 => tc('No'), 1 => tc('Yes')),
            'htmlOptions' => array(
                'data-title' => tt('Show_phones', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'limit_objects',
            'value' => '$data->getLimitObjectForGrid()',
            'sortable' => false,
            'htmlOptions' => array(
                'data-title' => tt('Limit_objects', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'limit_photos',
            'value' => '$data->getLimitPhotosForGrid()',
            'sortable' => false,
            'htmlOptions' => array(
                'data-title' => tt('Limit_photos', 'tariffPlans'),
            ),
        ),
        array(
            'header' => tt('Price', 'tariffPlans') . ', (' . Currency::getDefaultCurrencyModel()->name . ')',
            'name' => 'price',
            'value' => '$data->getPriceForGrid()',
            'sortable' => false,
            'htmlOptions' => array(
                'data-title' => tt('Price', 'tariffPlans'),
            ),
        ),
        array(
            'header' => tt('Duration', 'tariffPlans') . ', (' . tt('days') . ')',
            'name' => 'duration',
            'value' => '$data->getDurationForGrid()',
            'sortable' => false,
            'htmlOptions' => array(
                'data-title' => tt('Duration', 'tariffPlans'),
            ),
        ),
        array(
            'class' => 'bootstrap.widgets.BsButtonColumn',
            'deleteConfirmation' => tt('Are you sure you want to delete this item? All user tariffs will also be deleted!'),
            'template' => '{update} {delete}',
            'htmlOptions' => array('class' => 'infopages_buttons_column button_column_actions'),
            'buttons' => array(
                'delete' => array(
                    'visible' => '$data->id != TariffPlans::DEFAULT_TARIFF_PLAN_ID',
                ),
            ),
        ),
    ),
));

echo '<br /><br />';
echo '<h3>' . tt('No tariff plan', 'tariffPlans') . '</h3>';

$this->widget('CustomGridView', array(
    'allowNoMoreTables' => true,
    'id' => 'free-tariff-plans-grid',
    'dataProvider' => $freeModels->search(),
    'filter' => null,
    //'filter' => $freeModels,
    'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); attachStickyTableHeader();}',
    'columns' => array(
        array(
            'name' => 'show_address',
            'value' => '($data->show_address) ? tc("Yes") : tc("No")',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Show_address', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'show_phones',
            'value' => '($data->show_phones) ? tc("Yes") : tc("No")',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Show_phones', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'limit_objects',
            'value' => '$data->getLimitObjectForGrid()',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Limit_objects', 'tariffPlans'),
            ),
        ),
        array(
            'name' => 'limit_photos',
            'value' => '$data->getLimitPhotosForGrid()',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Limit_photos', 'tariffPlans'),
            ),
        ),
        array(
            'header' => tt('Price', 'tariffPlans') . ', (' . Currency::getDefaultCurrencyModel()->name . ')',
            'name' => 'price',
            'value' => '$data->getPriceForGrid()',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Price', 'tariffPlans'),
            ),
        ),
        array(
            'header' => tt('Duration', 'tariffPlans') . ', (' . tt('days') . ')',
            'name' => 'duration',
            'value' => '$data->getDurationForGrid()',
            'sortable' => false,
            'filter' => false,
            'htmlOptions' => array(
                'data-title' => tt('Duration', 'tariffPlans'),
            ),
        ),
        array(
            'class' => 'bootstrap.widgets.BsButtonColumn',
            'deleteConfirmation' => tt('Are you sure you want to delete this item? All user tariffs will also be deleted!'),
            'template' => '{update}',
            'htmlOptions' => array('class' => 'infopages_buttons_column button_column_actions'),
        ),
    ),
));
