<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>
    <?php echo $form->errorSummary($model); ?>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'name',
        'type' => 'string'
    ));

    ?>
    <div class="clear"></div>

    <?php if ($model->id != TariffPlans::DEFAULT_TARIFF_PLAN_ID): ?>
        <?php
        $this->widget('application.modules.lang.components.langFieldWidget', array(
            'model' => $model,
            'field' => 'description',
            'type' => 'text-editor'
        ));

        ?>
        <div class="clear"></div><br/>

        <div class="form-group">
            <?php echo $form->labelEx($model, 'for_user_type_id'); ?>
            <?php echo $form->dropDownList($model, 'for_user_type_id', User::getTypeList(), array('class' => 'span2')); ?>
            <?php echo $form->error($model, 'for_user_type_id'); ?>
        </div>
        <div class="clear"></div><br/>
    <?php endif; ?>

    <fieldset>
        <legend><?php echo tt('Browse ads', 'tariffPlans'); ?></legend>

        <div class="form-group">
            <?php echo $form->checkboxControlGroup($model, 'show_address'); ?>
        </div>

        <div class="form-group">
            <?php echo $form->checkboxControlGroup($model, 'show_phones'); ?>
        </div>

    </fieldset>

    <div class="clear"></div>
    <br/>

    <fieldset>
        <legend><?php echo tt('Adding ads', 'tariffPlans'); ?></legend>

        <div class="form-group">
            <?php echo $form->labelEx($model, 'limit_objects'); ?>
            <?php echo $form->textField($model, 'limit_objects', array('class' => 'width50')); ?>
            <?php echo $form->error($model, 'limit_objects'); ?>
        </div>
        <div class="clear"></div>

        <div class="form-group">
            <?php echo $form->labelEx($model, 'limit_photos'); ?>
            <?php echo $form->textField($model, 'limit_photos', array('class' => 'width50')); ?>
            <span class="label label-info">
                <?php echo tt('If null or 0 then unlimited'); ?>
            </span>
            <?php echo $form->error($model, 'limit_photos'); ?>
        </div>
        <div class="clear"></div>
        <br/>
    </fieldset>

    <?php if ($model->id != TariffPlans::DEFAULT_TARIFF_PLAN_ID): ?>
        <fieldset>
            <legend><?php echo tt('Duration and price', 'tariffPlans'); ?></legend>

            <div class="form-group">
                <?php echo $form->labelEx($model, 'duration'); ?>
                <div>
                    <?php echo $form->textField($model, 'duration', array('class' => 'width50 noblock')); ?>
                    <span><?php echo tt('days'); ?></span>
                </div>
                <?php echo $form->error($model, 'duration'); ?>
            </div>
            <div class="clear"></div>

            <div class="form-group">
                <?php echo $form->labelEx($model, 'price'); ?>
                <div>
                    <?php echo $form->textField($model, 'price', array('class' => 'width50 noblock')); ?>
                    <span><?php echo Currency::getDefaultCurrencyModel()->name; ?></span>
                    <?php echo $form->error($model, 'price'); ?>
                </div>

            </div>
            <div class="clear"></div>
        </fieldset>
    <?php endif; ?>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->