<?php
$this->pageTitle = Yii::app()->name . ' - ' . SocialpostingModule::t('Configure the services of automatic posting');

$this->breadcrumbs = array(
    SocialpostingModule::t('Services of automatic posting') => array('/socialposting/backend/main'),
    SocialpostingModule::t('Update {name}', array('{name}' => $model->title)),
);

$this->adminTitle = SocialpostingModule::t('Update param "{name}"', array('{name}' => $model->title));

if ($ajax) {

    ?>
    <script>$(".modal-header h3").html("<?php echo CHtml::encode($this->adminTitle); ?>")</script>
<?php } ?>

<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => true,
        'htmlOptions' => array('class' => 'white_noborder well form-disable-button-after-submit')
    ));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <input type="hidden" name="config_id" id="config_id" value="<?php echo $model->id; ?>">

    <div class="form-group">
        <?php echo $form->labelEx($model, 'value'); ?>
        <?php echo $form->textArea($model, 'value', array('class' => 'width450 form-control', 'id' => 'config_value')); ?>
        <?php echo $form->error($model, 'value'); ?>
    </div>

    <?php if (!$ajax) { ?>
        <div class="form-group buttons">
            <?php
            $this->widget('bootstrap.widgets.TbButton', array('buttonType' => 'submit',
                'type' => 'primary',
                'icon' => 'ok white',
                'label' => tc('Save'),
                'htmlOptions' => array(
                    'class' => 'submit-button',
                ),
            ));

            ?>
        </div>
    <?php } ?>

    <?php $this->endWidget(); ?>

</div><!-- form -->
