<?php
$afterRefresh = isset($afterRefresh) ? $afterRefresh : false;
$image = $this->image;
$languages = (!isFree()) ? Lang::getActiveLangs(true) : null;

$this->beginWidget('zii.widgets.jui.CJuiDialog', array(
    'id' => 'image_dialog_' . $image->id,
    'options' => array(
        'autoOpen' => false,
        'width' => '700px',
        'modal' => true,
        'resizable' => true,
        'closeOnEscape' => true,
    ),
));

?>

<div class="form image_html" id="image_html_<?php echo $image->id; ?>">
    <?php $this->render('_carousel_image_form', array('image' => $image)); ?>
</div><!-- form -->

<?php $this->endWidget('zii.widgets.jui.CJuiDialog'); ?>

<?php if ($afterRefresh) { ?>
    <script>
        $(function () {
            jQuery('#image_dialog_<?php echo $image->id; ?>').dialog({
                'autoOpen': false,
                'width': '700px',
                'modal': true,
                'resizable': true,
                'closeOnEscape': true
            });
            <?php if ($languages && count($languages) > 1) { ?>
            jQuery('#image_dialog_<?php echo $image->id; ?>').find('div.yiiTab').yiitab();
            <?php } ?>
        });
    </script>
<?php } ?>
