<?php
$this->pageTitle = Yii::app()->name . ' - ' . SliderModule::t('Manage carousel');

$this->menu = array(
    AdminLteHelper::getAddMenuLink(SliderModule::t('Add carousel'), array('create')),
);
$this->adminTitle = SliderModule::t('Manage carousel');

?>

<?php
$this->widget('CustomGridView', array(
    'allowNoMoreTables' => true,
    'id' => 'slider-grid',
    'dataProvider' => $model->search(),
    'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); $("a.fancy").fancybox(); attachStickyTableHeader();}',
    'rowCssClassExpression' => '"items[]_{$data->id}"',
    'rowHtmlOptionsExpression' => 'array("data-bid"=>"items[]_{$data->id}")',
    'filter' => $model,
    'columns' => array(
        array(
            'class' => 'CCheckBoxColumn',
            'id' => 'itemsSelected',
            'selectableRows' => '2',
            'htmlOptions' => array(
                'class' => 'center',
                'data-title' => tc('Actions'),
            ),
        ),
        array(
            'name' => 'name',
            'header' => tc('Name'),
            'htmlOptions' => array(
                'data-title' => tc('Name'),
            ),
        ),
        array(
            'header' => tt('Code'),
            'value' => '$data->getCode()',
            'htmlOptions' => array(
                'data-title' => tt('Code'),
            ),
        ),
        array(
            'class' => 'bootstrap.widgets.BsButtonColumn',
            'template' => '{update} {delete}',
            'htmlOptions' => array('class' => 'infopages_buttons_column button_column_actions'),
            'deleteConfirmation' => tc('Are you sure you want to delete this item?'),
        ),
    ),
));

?>

<?php
$this->renderPartial('//site/admin-select-items', array(
    'url' => '/slider/backend/main/itemsSelected',
    'id' => 'slider-grid',
    'model' => $model,
    'options' => array(
        'delete' => Yii::t('common', 'Delete')
    ),
));

$csrf_token_name = Yii::app()->request->csrfTokenName;
$csrf_token = Yii::app()->request->csrfToken;

/*
 *
Yii::app()->getClientScript()->registerCoreScript('jquery.ui');

$str_js = "
		var fixHelper = function(e, ui) {
			ui.children().each(function() {
				$(this).width($(this).width());
			});
			return ui;
		};

		function reInstallSortable(id, data) {
			installSortable();
		}

		function updateGrid() {
			$.fn.yiiGridView.update('slider-grid');
		}

		function installSortable() {
			if ($(window).width() > 767) {
				$('#slider-grid table.items tbody').sortable({
					forcePlaceholderSize: true,
					forceHelperSize: true,
					items: 'tr',
					update : function () {
						serial = $('#slider-grid table.items tbody').sortable('serialize', {key: 'items[]', attribute: 'data-bid'}) + '&{$csrf_token_name}={$csrf_token}';
						$.ajax({
							'url': '" . $this->createUrl('/slider/backend/main/sortitems') . "',
							'type': 'post',
							'data': serial,
							'success': function(data){
								updateGrid();
							},
							'error': function(request, status, error){
								alert('We are unable to set the sort order at this time.  Please try again in a few minutes.');
							}
						});
					},
					helper: fixHelper
				}).disableSelection();
			}
		}

		installSortable();
";

$cs->registerScript('sortable-project', $str_js);*/