<?php
include 'style.php';

//Yii::app()->getClientScript()->registerCoreScript('jquery.ui');

?>

<div class="form">

    <?php if ($model->status != Carousel::STATUS_DRAFT && $model->images) { ?>
        <div class="alert alert-info">
            <strong><?php echo tt('Code') . ': ' ?></strong>
            <?php echo $model->getCode(); ?>
        </div>
    <?php } ?>

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => 'Carousel-form',
        'enableClientValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data', 'class' => 'well form-disable-button-after-submit'),
    ));

    ?>

    <div class="form-group">
        <?php echo $form->labelEx($model, 'name'); ?>
        <?php echo $form->textField($model, 'name', array('class' => 'from-control')); ?>
        <?php echo $form->error($model, 'name'); ?>
    </div>

    <div class="images-carousel-area">
        <?php
        $this->widget('application.modules.slider.components.CarouselAdminWidget', array(
            'images' => $model->images,
            'model' => $model,
        ));

        ?>
    </div>

    <div class="clear"></div>

    <div class="form-group">
        <label for=""><?php echo tc('Photos for carousel'); ?></label>
        <?php
        $this->widget('ext.EAjaxUpload.EAjaxUpload', array(
                'id' => 'uploadFile',
                'config' => array(
                    'action' => Yii::app()->createUrl('/slider/backend/carousel/uploadImages', array('id' => $model->id)),
                    'allowedExtensions' => param('allowedImgExtensions', array('jpg', 'jpeg', 'gif', 'png')),
                    //'sizeLimit' => param('maxImgFileSize', 8 * 1024 * 1024),
                    'postParams' => array(Yii::app()->request->csrfTokenName => Yii::app()->request->csrfToken),
                    'sizeLimit' => Images::getMaxSizeLimit(),
                    'minSizeLimit' => param('minImgFileSize', 5 * 1024),
                    'multiple' => true,
                    'onComplete' => "js:function(id, fileName, responseJSON){ reloadImagesArea(); }",
                    /* 'onSubmit' => 'js:function(id, fileName){  }', */
                    'messages' => array(
                        'typeError' => tc("{file} has invalid extension. Only {extensions} are allowed."),
                        'sizeError' => tc("{file} is too large, maximum file size is {sizeLimit}."),
                        'minSizeError' => tc("{file} is too small, minimum file size is {minSizeLimit}."),
                        'emptyError' => tc("{file} is empty, please select files again without it."),
                        'onLeave' => tc("The files are being uploaded, if you leave now the upload will be cancelled."),
                    ),
                    'showMessage' => "js:function(result){ alert(result); }"
                )
            )
        );

        ?>
    </div>
    <div class="clear">&nbsp;</div>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>
    </div>
    <?php $this->endWidget(); ?>

</div><!-- form -->



