<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

/**
 * This is the model class for table "{{carousel_images}}".
 *
 * The followings are the available columns in table '{{carousel_images}}':
 * @property integer $id
 * @property integer $active
 * @property integer $carousel_id
 * @property integer $sorter
 * @property string $image
 */
class CarouselImages extends ParentModel
{

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{carousel_images}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        return array(
            array('carousel_id, image', 'required'),
            array('active, carousel_id, sorter', 'numerical', 'integerOnly' => true),
            array('image', 'length', 'max' => 255),
            array($this->getI18nFieldSafe(), 'safe'),
            array('id, active, carousel_id, sorter, image', 'safe', 'on' => 'search'),
        );
    }

    public function i18nFields()
    {
        return array(
            'title' => 'varchar(255) not null default ""',
            'text' => 'text null',
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'active' => 'Active',
            'carousel_id' => 'Carousel',
            'sorter' => 'Sorter',
            'image' => 'Image',
            'title' => Yii::t('slider', 'Title'),
            'text' => Yii::t('slider', 'Text'),
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('active', $this->active);
        $criteria->compare('carousel_id', $this->carousel_id);
        $criteria->compare('sorter', $this->sorter);
        $criteria->compare('image', $this->image, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return CarouselImages the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    public function getThumbUrl($width = 100, $height = 62)
    {
        $path = Carousel::getUploadPath() . DIRECTORY_SEPARATOR . $this->carousel_id;
        $fileName = 'thumb_' . $width . 'x' . $height . "_" . $this->image;
        $filePath = $path . DIRECTORY_SEPARATOR . $fileName;

        if (file_exists($filePath)) {
            return Carousel::getUploadDir() . '/' . $this->carousel_id . '/' . $fileName;
        } else {
            if (file_exists($path . DIRECTORY_SEPARATOR . $this->image)) {
                $useEffect = 1;

                Yii::import('application.extensions.image.Image');
                $image = new Image($path . DIRECTORY_SEPARATOR . $this->image);

                if ($useEffect) {
                    $image->resizeWithEffect($width, $height);
                } else {
                    $image->resize($width, $height);
                }
                $image->quality(param('thumbQuality', 75))->save($filePath);
                return Carousel::getUploadDir() . '/' . $this->carousel_id . '/' . $fileName;
            }
            return null;
        }
    }

    public function getImagePath()
    {
        return Carousel::getUploadPath() . DIRECTORY_SEPARATOR . $this->carousel_id . DIRECTORY_SEPARATOR . $this->image;
    }

    public function getImageUrl()
    {
        return Carousel::getUploadDir() . '/' . $this->carousel_id . '/' . $this->image;
    }

    public function beforeDelete()
    {
        $imagePath = self::getImagePath();
        if (file_exists($imagePath)) {
            //@unlink($imagePath);
            @array_map("unlink", glob(Carousel::getUploadPath() . DIRECTORY_SEPARATOR . $this->carousel_id . "/*" . $this->image));
        }

        return parent::beforeDelete();
    }

    public function getTitle()
    {
        return $this->getStrByLang('title');
    }

    public function getText()
    {
        return $this->getStrByLang('text');
    }
}
