<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class CarouselViewWidget extends CWidget
{

    public $name;
    public $model;

    public function getViewPath($checkTheme = false)
    {
        if ($checkTheme && ($theme = Yii::app()->getTheme()) !== null) {
            if (is_dir($theme->getViewPath() . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR . 'slider' . DIRECTORY_SEPARATOR . 'views'))
                return $theme->getViewPath() . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR . 'slider' . DIRECTORY_SEPARATOR . 'views';
        }
        return Yii::getPathOfAlias('application.modules.slider.views');
    }

    public function run()
    {
//        $model = Carousel::model()->findByAttributes(array('name' => $this->name));
        if (!$this->model) {
            return;
        }

        $this->registerAssets();

        $this->render('carousel_widget', array('model' => $this->model));
    }

    public function registerAssets()
    {
        $assets = dirname(__FILE__) . '/../assets_carousel';
        $baseUrl = Yii::app()->assetManager->publish($assets);

        if (is_dir($assets)) {

            Yii::app()->clientScript->registerCoreScript('jquery');
            Yii::app()->clientScript->registerScriptFile($baseUrl . '/carousel_ck/js/jquery.easing.1.3.js', CClientScript::POS_END);
            //Yii::app()->clientScript->registerScriptFile($baseUrl . '/carousel_ck/js/jquery.mobile.min.js', CClientScript::POS_END);
            Yii::app()->clientScript->registerScriptFile($baseUrl . '/carousel_ck/js/carouselck.js', CClientScript::POS_END);

            Yii::app()->clientScript->registerCssFile($baseUrl . '/carousel_ck/themes/default/css/carouselck.css');
            Yii::app()->clientScript->registerCssFile($baseUrl . '/carousel_ck/themes/default/css/carouselck_ie.css');
            Yii::app()->clientScript->registerCssFile($baseUrl . '/carousel_ck/themes/default/css/carouselck_ie8.css');

            Yii::app()->clientScript->registerScript('carousel_ck' . $this->model->id, '
				$("#carousel_' . $this->model->id . '").carouselck({
                        wrapheight: "40",
                        imageheight: "62",
                        imagesratio: "0.72",
                        pagination: 1,
                        duration: 600,
                        time: 2000,
                        captionduration: 600,
                        autoAdvance: 1,
                        lightbox: "mediaboxck",
                        //imagePath: "/modules/mod_carouselck/images/",
                        navigationHover: true,
                        navigation: true,
                        playPause: 1,
                        hover: true
                });
			', CClientScript::POS_READY);
        } else {
            throw new Exception('Image - Error: Couldn\'t find assets folder to publish.');
        }
    }
}
