<?php
/** @var $model SitemapConfig */

$this->adminTitle = tc('Sitemap setup');
$this->breadcrumbs = array(
    tc('Sitemap setup'),
);

$this->menu = array(
    AdminLteHelper::getMenuLink(SitemapModule::t('Site map'), array('/sitemap'), 'fa fa-eye'),
    //AdminLteHelper::getMenuLink('sitemap.xml', array('/sitemap.xml'), 'fa fa-eye'),
);

?>

<style>
    .url-removed {
        text-decoration: line-through;
    }
</style>

<div class="site-map-main">

    <div class="alert alert-light-warning">
        <p>
            <?= tt('Specify the url you want to hide.') ?>
        </p>
    </div>

    <div class="form">

        <?php
        $form = $this->beginWidget('CustomForm', array(
            'id' => 'Slider-form',
            'enableClientValidation' => false,
            'htmlOptions' => array(
                'enctype' => 'multipart/form-data', 'class' => 'well form-disable-button-after-submit'
            ),
        ));

        $removedUrls = $model->getRemovedUrls();
        ?>

        <?php
        echo '<ul class="site_map">';
        foreach ($model->map as $item) {
            echo \application\modules\sitemap\helpers\SitemapHelper::getLiRow($item, $removedUrls);

            if (isset($item['subsection']) && count($item['subsection']) > 0) {
                echo '<ul class="sm_subsection">';
                foreach ($item['subsection'] as $value) {
                    if (isset($value['url']) && is_array($value['url'])) {
                        continue;
                    }

                    echo \application\modules\sitemap\helpers\SitemapHelper::getLiRow($value, $removedUrls);
                }
                echo '</ul>';
            }
        }
        echo '</ul>';
        ?>

        <?php
        $this->widget('application.modules.lang.components.langFieldWidget', array(
            'model' => $model,
            'field' => 'body',
            'type' => 'text-editor'
        ));
        ?>

        <div class="form-group buttons">
            <?php
            echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

            ?>
        </div>
        <?php $this->endWidget(); ?>
    </div>
</div>

<?php

$script = <<< js

$('input.sitemap-url').on('click', function() {
    let isChecked = $(this).is(':checked');
    
    if(isChecked){
        $(this).next('a.sitemap-url').addClass('url-removed');
    } else {
        $(this).next('a.sitemap-url').removeClass('url-removed');
    }
});

js;

Yii::app()->clientScript->registerScript('sitemap-js', $script, \CClientScript::POS_READY);
?>