<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

/**
 * This is the model class for table "{{sitemap_config}}".
 *
 * The followings are the available columns in table '{{sitemap_config}}':
 * @property integer $id
 * @property string $body_ru
 * @property string $body_en
 * @property string $body_de
 * @property string $body_es
 * @property string $body_ar
 * @property string $body_tr
 * @property string $config_json
 *
 * @mixin JsonBehavior
 */
class SitemapConfig extends ParentModel
{
    public $map = [];

    public function behaviors()
    {
        $arr['JsonBehavior'] = array(
            'class' => 'application.components.behaviors.JsonBehavior',
            'jsonField' => 'config_json'
        );

        return $arr;
    }

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{sitemap_config}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('config_json', 'safe'),
            array($this->getI18nFieldSafe(), 'safe'),
			array('id, config_json', 'safe', 'on'=>'search'),
		);
	}

    public function i18nFields()
    {
        return array(
            'body' => 'LONGTEXT null',
        );
    }

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'body' => tc('Body'),
			'config_json' => 'Config Json',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('body_ru',$this->body_ru,true);
		$criteria->compare('body_en',$this->body_en,true);
		$criteria->compare('body_de',$this->body_de,true);
		$criteria->compare('body_es',$this->body_es,true);
		$criteria->compare('body_ar',$this->body_ar,true);
		$criteria->compare('body_tr',$this->body_tr,true);
		$criteria->compare('config_json',$this->config_json,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SitemapConfig the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

    public function getRemovedUrls()
    {
        return $this->getFromJson('removed_urls', []);
	}
}
