<?php
namespace application\modules\sitemap\helpers;

class SitemapHelper
{
    public static function getLiRow($item, $removedUrls)
    {
        $html = '';

        if (isset($item['title'])) {
            $html = '<li>';
            if (isset($item['url'])) {
                $isRemoved = in_array($item['url'], $removedUrls);
                $class = $isRemoved ? 'sitemap-url url-removed' : 'sitemap-url';

                $html .= \CHtml::checkBox('rem['.$item['url'].']', $isRemoved, [
                    'value' => $item['url'],
                    'class' => $class,
                ]);
                $html .= '&nbsp;';
                $html .= '<a href="'.$item['url'].'" class="'.$class.'" target="_blank">';
            }
            $html .= $item['title'];
            if (isset($item['url'])) {
                $html .= '</a>';
            }
            $html .= '</li>';
        }

        return $html;
    }
}