<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

use \application\modules\sitemap\repositories\SitemapRepository;
use \application\modules\sitemap\repositories\SitemapConfigRepository;
use \application\modules\sitemap\services\SitemapConfigStorageService;

class MainController extends ModuleAdminController
{
    /** @var SitemapRepository */
    private $mapRepo;

    /** @var SitemapConfigRepository */
    private $configRepo;

    /** @var SitemapConfigStorageService */
    private $storage;

    public function init()
    {
        $this->mapRepo = new SitemapRepository();
        $this->configRepo = new SitemapConfigRepository();
        $this->storage = new SitemapConfigStorageService();

        parent::init();
    }

    public function actionSetup()
    {
        $model = $this->configRepo->getModelConfig();
        $model->map = $this->mapRepo->generateMap(false, false);

        if(isset($_POST['SitemapConfig'])){
            $model->attributes = $_POST['SitemapConfig'];
            if($this->storage->save($model)){
                Yii::app()->user->setFlash('success', tc('Success'));
            }
        }

        $this->render('config', [
            'model' => $model,
        ]);
    }
}