<?php
/* * ********************************************************************************************
 * 								Open Real Estate
 * 								----------------
 * 	version				:	V1.36.0
 * 	copyright			:	(c) 2016 Monoray
 * 							http://monoray.net
 * 							http://monoray.ru
 *
 * 	website				:	http://open-real-estate.info/en
 *
 * 	contact us			:	http://open-real-estate.info/en/contact-us
 *
 * 	license:			:	http://open-real-estate.info/en/license
 * 							http://open-real-estate.info/ru/license
 *
 * This file is part of Open Real Estate
 *
 * ********************************************************************************************* */

class MainController extends ModuleUserController
{
    public $modelName = 'Sitemap';
    public $defaultAction = 'index';
    public $changefreq = 'daily';
    public $priority = '0.5';

    public $isXml = 0;
    public $userLang;

    /** @var \application\modules\sitemap\repositories\SitemapRepository */
    private $repository;

    public function init()
    {
        if (!oreInstall::isInstalled() && !(Yii::app()->controller->module && Yii::app()->controller->module->id == 'install')) {
            $this->redirect(array('/install'));
        }

        setLang();

        $this->showSearchForm = false;

        $this->userLang = Yii::app()->language;

        $this->repository = new \application\modules\sitemap\repositories\SitemapRepository();

        parent::init();
    }

    public function actionIndex()
    {
        if (!$this->isXml) {
            Sitemap::publishAssets();
        }

        $map = $this->repository->generateMap($this->isXml);

        $this->render('index', [
            'map' => $map,
            'config' => (new \application\modules\sitemap\repositories\SitemapConfigRepository())->getModelConfig()
        ]);
    }

    public function actionViewXml()
    {
        Controller::disableProfiler();
        $this->isXml = 1;

        $map = $this->repository->generateMap($this->isXml);

        if (is_array($map) && count($map) > 0) {
            header('Content-type: text/xml');
            header('Pragma: public');
            header('Cache-control: private');
            header('Expires: -1');

            $resSiteMap = Yii::app()->cache->get("siteMapXml{$this->userLang}");
            if ($resSiteMap !== false) {
                echo $resSiteMap;
                Yii::app()->end();
            }

            $xml = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><urlset/>');
            $xml->addAttribute('xmlns', 'http://www.sitemaps.org/schemas/sitemap/0.9');

            foreach ($map as $item) {
                if (isset($item['url'])) {
                    $this->prepareItem($item, $xml);
                }
                if (isset($item['subsection']) && count($item['subsection']) > 0) {
                    foreach ($item['subsection'] as $value) {
                        if (isset($value['url'])) {
                            $this->prepareItem($value, $xml);
                        }
                        if (isset($value['apartments']) && count($value['apartments']) > 0) {
                            foreach ($value['apartments'] as $apartment) {
                                if (isset($apartment['url'])) {
                                    $this->prepareItem($apartment, $xml);
                                }
                            }
                        }
                    }
                }
            }

            $res = $xml->asXML();

            if (param('cachingTime')) {
                Yii::app()->cache->set("siteMapXml{$this->userLang}", $res, 60 * 60 * param('cachingTime'));
            }

            echo $res;
            Yii::app()->end();
        } else {
            echo 'no elements';
        }
    }

    public function prepareItem($item = array(), $xml = null)
    {
        if (!empty($item) && $xml) {
            if (is_string($item['url'])) {
                $elem = $xml->addChild('url');

                $elem->addChild('loc', $item['url']);
                if (isset($item['lastmod'])) {
                    $elem->addChild('lastmod', $item['lastmod']);
                }
                $elem->addChild('changefreq', $this->changefreq);
                $elem->addChild('priority', $this->priority);
            } elseif (is_array($item['url'])) {
                foreach ($item['url'] as $keyUrl => $valUrl) {
                    if (isset($item['url'][$keyUrl]) && is_array($item['url'][$keyUrl])) {
                        continue;
                    }

                    if (isset($item['url'][$keyUrl]) && !empty($item['url'][$keyUrl])) {
                        $elem = $xml->addChild('url');
                        $elem->addChild('loc', $item['url'][$keyUrl]);

                        if (isset($item['lastmod'][$keyUrl])) {
                            $elem->addChild('lastmod', $item['lastmod'][$keyUrl]);
                        }
                        $elem->addChild('changefreq', $this->changefreq);
                        $elem->addChild('priority', $this->priority);
                    }
                }
            }
        }
    }

}
