<div class="clear">&nbsp;</div>

<?php
$this->pageTitle = Yii::app()->name . ' - ' . tc('Manage SEO search');
$this->adminTitle = tc('Manage SEO search');

$this->menu = array(
    AdminLteHelper::getAddMenuLink(tt('Add compliance'), array('create')),
);

$this->widget('CustomGridView', array(
    'dataProvider' => $model->search(),
    'filter' => $model,
    'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); attachStickyTableHeader();}',
    'columns' => array(
        array(
            'header' => tt('Type'),
            'name' => 'type',
            'type' => 'raw',
            'value' => '$data->getTypeName()',
            'filter' => SeoFriendlyUrlSearch::getTypeList(),
            'htmlOptions' => array(
                'data-title' => tt('Type'),
            ),
        ),
        array(
            'header' => tt('Search / Url'), //Поиск (Тип/Недвижимость/ГО/Комнат)
            'name' => 'url',
            'type' => 'raw',
            'value' => '$data->getUrlForTable()',
            'htmlOptions' => array(
                'data-title' => tt('URL'),
            ),
            'filter' => false,
        ),
        //'canonical_url',
        array(
            'header' => $model->getAttributeLabel('title'),
            'name' => 'title_' . Yii::app()->language,
            'type' => 'raw',
            'htmlOptions' => array(
                'data-title' => tt('Title', 'seo'),
            ),
        ),
        //'is_noindex',
        array(
            'class' => 'bootstrap.widgets.BsButtonColumn',
            'template' => '{update}{delete}',
            'htmlOptions' => array('class' => 'width50 button_column_actions'),
        ),
    ),
));

?>

<div class="clear">&nbsp;</div>
