<?php
/** @var $form CustomForm */
?>

<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => 'seo-form',
        'enableClientValidation' => false,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));

    ?>
    <p class="note">
        <?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?>
    </p>

    <?php echo $form->errorSummary($model); ?>

    <div class="form-group">
        <?= $form->dropDownListControlGroup($model, 'type', SeoFriendlyUrlSearch::getTypeList(), array('id' => 's-type')) ?>
    </div>

    <div class="filter-obj">
        <?php include '_search.php' ?>
    </div>

    <div class="form-group" id="url-row">
        <?php echo $form->labelEx($model, 'url'); ?>
        <div class="form_tip"><?= tt('Example').': search?apType=1&objType=1' ?></div>
        <?php echo $form->textField($model, 'url', array('class' => 'width500', 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'url'); ?>
    </div>

    <div class="form-group ss-type-1">
        <?php echo $form->labelEx($model, 'canonical_url'); ?>
        <?php echo $form->textField($model, 'canonical_url', array('class' => 'width500', 'maxlength' => 255)); ?>
        <?php echo $form->error($model, 'canonical_url'); ?>
    </div>

    <?php if(0){ ?>
    <div class="form-group ss-type-1">
        <?php echo $form->checkboxControlGroup($model, 'is_noindex'); ?>
    </div>
    <?php } ?>

    <br/>

    <div class="row">
        <div class="col-md-7">
            <?php
            $this->widget('application.modules.lang.components.langFieldWidget', array(
                'model' => $model,
                'field' => 'title',
                'type' => 'string',
            ));

            ?>

            <?php
            $this->widget('application.modules.lang.components.langFieldWidget', array(
                'model' => $model,
                'field' => 'description',
                'type' => 'string'
            ));
            ?>

            <?php
            $this->widget('application.modules.lang.components.langFieldWidget', array(
                'model' => $model,
                'field' => 'keywords',
                'type' => 'string',
            ));
            ?>

            <hr>

            <?php
            $this->widget('application.modules.lang.components.langFieldWidget', array(
                'model' => $model,
                'field' => 'h1',
                'type' => 'string',
            ));
            ?>
        </div>
        <div class="col-md-5">
            <div class="note">
                <pre>
                    {country} - <?= tc('Country') ?>

                    {region} - <?= tc('Region') ?>

                    {city} - <?= tc('City') ?>

                    {metro} - <?= tt('Metro', 'apartments') ?>

                    {type_deal} - <?= tt('Type', 'apartments') ?>

                    {type_estate} - <?= tc('Property type') ?>

                </pre>
            </div>
        </div>
    </div>

    <div class="ss-type-1">
        <?php
        $this->widget('application.modules.lang.components.langFieldWidget', array(
            'model' => $model,
            'field' => 'body',
            'type' => 'text-editor',
        ));
        ?>
    </div>

    <br/>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->


<?php
$js = <<< JS
    
    function checkSearchType() {
        var type = $('#s-type').val();
        
        if(type == 1){
            $('#url-row').show();
            $('#seo-form .ss-type-1').show();
            $('#filter-row').hide();
        } else if(type == 2){
            $('#url-row').hide();
            $('#seo-form .ss-type-1').hide();
            $('#filter-row').show(); 
        }
    }
    
    $(function() {
        checkSearchType();
        
        $('#s-type').on('change', checkSearchType);
    });


JS;

Yii::app()->clientScript->registerScript('ch', $js, CClientScript::POS_END);
?>

