<?php
/**
 * @var $model SeoSettings
 * @var $form CustomForm
 */

?>
<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => 'seo-form',
        'enableAjaxValidation' => true,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <?php
    echo $form->errorSummary($model->models);

    foreach ($model->models as $key => $tm) {
        //deb($tm->message);
        $this->widget('application.modules.lang.components.langFieldWidget', array(
            'model' => $tm,
            'field' => 'translation',
            'type' => 'text',
            'fieldPrefix' => '[' . $key . ']',
            'labelSet' => $model->getLabel($tm->message),
        ));
    }

    echo '<hr>';

    echo $form->checkboxControlGroup($settingsForm, 'urlExtension');
    echo $form->checkboxControlGroup($settingsForm, 'allowUserSeo');
    echo $form->checkboxControlGroup($settingsForm, 'useSchemaOrgMarkup');
    echo $form->checkboxControlGroup($settingsForm, 'useSeoSearchConfigByLink');
    echo $form->checkboxControlGroup($settingsForm, 'useSeoSearchConfigBySearch');

    ?>
    <div class="clear"></div>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton(tc('Save'));

        ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->