<?php
$this->adminTitle = Yii::t('module_payment', 'Payment System Settings');

$model->payModel->printInfo();

?>
<div class="form">

    <?php echo CHtml::beginForm('', 'post', array('class' => 'well form-disable-button-after-submit')); ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <?php echo CHtml::errorSummary(array($model, $model->payModel), '', '', array('class' => 'alert alert-block alert-error')); ?>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'name',
        'type' => 'string',
    ));

    ?>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'description',
        'type' => 'text-editor',
    ));

    ?>

    <?php
    $this->renderPartial('paymentsystems/' . $model->viewName, array('model' => $model->payModel));

    ?>

    <div class="form-group">
        <?php echo CHtml::activeLabelEx($model, 'active'); ?>
        <?php echo CHtml::activeDropDownList($model, 'active', $this->getStatusOptions(), array('class' => 'form-control')); ?>
        <?php echo CHtml::error($model, 'active'); ?>
    </div>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton(tc('Save'));

        ?>
    </div>

    <?php echo CHtml::endForm(); ?>

</div><!-- form -->