<?php
$this->pageTitle = Yii::app()->name . ' - ' . tt('Manage payments', 'payment');

$this->menu = array(
    array(),
);

$this->adminTitle = tt('Manage payments', 'payment');

$columns = array(
    array(
        'name' => 'id',
        'htmlOptions' => array(
            'class' => 'id_column',
            'data-title' => tt('ID', 'apartments'),
        ),
    ),
    array(
        'name' => 'status',
        'type' => 'raw',
        'value' => '$data->returnStatusHtml()',
        'htmlOptions' => array(
            'class' => 'width150',
            'data-title' => tc('Status'),
        ),
        'filter' => CHtml::dropDownList('Payments[status]', $model->status, $model->getStatuses(), array('class' => 'form-control')),
    ),
    array(
        'header' => tc('User'),
        'type' => 'raw',
        'value' => 'isset($data->user) ? CHtml::link(CHtml::encode($data->user->username),array("/users/backend/main/view","id" => $data->user->id)) : ""',
        'htmlOptions' => array(
            'data-title' => tc('User'),
        ),
    ),
    array(
        'name' => 'apartment_id',
        'type' => 'raw',
        'value' => '(isset($data->ad) && $data->ad->id) ? CHtml::link($data->ad->id, $data->ad->getUrl()) : tc("No")',
        'filter' => false,
        'sortable' => true,
        'htmlOptions' => array(
            'data-title' => Yii::t('module_comments', 'Apartment_id'),
        ),
    )
);

if (issetModule('tariffPlans')) {
    $columns[] = array(
        'header' => tt('Tariff_id', 'tariffPlans'),
        'name' => 'tariff_id',
        'type' => 'raw',
        'value' => '(isset($data->tariffInfo) && $data->tariffInfo->name) ? $data->tariffInfo->name : tc("No")',
        'filter' => false,
        'sortable' => false,
        'htmlOptions' => array(
            'data-title' => Yii::t('module_tariffPlans', 'Tariff_id'),
        ),
    );
}

$columns[] = array(
    'header' => tc('Paid Service'),
    'type' => 'raw',
    'value' => '$data->getPaidserviceName()',
    'htmlOptions' => array(
        'data-title' => tc('Paid Service'),
    ),
);

$columns[] = array(
    'name' => 'paysystem_name',
    'type' => 'raw',
    'value' => '(isset($data->paysystem) && $data->paysystem) ? $data->paysystem->name : ""',
    'htmlOptions' => array(
        'data-title' => tt('Method of payment'),
    ),
);

$columns[] = array(
    'name' => 'amount',
    'type' => 'raw',
    'value' => '$data->amount . " " . $data->currency_charcode',
    'htmlOptions' => array(
        'class' => 'width100',
        'data-title' => tt('Amount'),
    ),
);

$columns[] = array(
    'name' => 'date_created',
    'type' => 'raw',
    'filter' => false,
    'htmlOptions' => array(
        'class' => 'width130',
        'data-title' => tt('Payment date'),
    ),
);

$columns[] = array(
    'class' => 'bootstrap.widgets.BsButtonColumn',
    'template' => '{confirm} {delete}',
    'htmlOptions' => array(
        'class' => 'width100 button_column_actions',
    ),
    'buttons' => array(
        'delete' => array(
            'visible' => '$data->status == Payments::STATUS_WAITPAYMENT || $data->status == Payments::STATUS_WAITOFFLINE',
        ),
        'confirm' => array(
            'visible' => '$data->status == Payments::STATUS_WAITOFFLINE',
            'options' => array('class' => 'infopages_arrow_image_fast_up glyphicon glyphicon glyphicon-ok', 'title' => tt('Confirm payment')),
            'url' => 'Yii::app()->createUrl("/payment/backend/main/confirm", array("id"=>$data->id))',
            'label' => '',
        ),
    )
);

$this->widget('CustomGridView', array(
        'allowNoMoreTables' => true,
        'dataProvider' => $model->search(),
        'filter' => $model,
        'afterAjaxUpdate' => 'function(){$("a[rel=\'tooltip\']").tooltip(); $("div.tooltip-arrow").remove(); $("div.tooltip-inner").remove(); attachStickyTableHeader();}',
        'columns' => $columns
    )
);
