<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>

    <?php
    if ($dataModel) {
        echo $form->errorSummary(array($model, $dataModel));
    } else {
        echo $form->errorSummary($model);
    }

    ?>

    <?php echo $form->labelEx($model, 'active'); ?>
    <?php
    echo $form->dropDownList($model, 'active', array(
        '1' => tt('Active', 'apartments'),
        '0' => tt('Inactive', 'apartments'),
    ), array('class' => 'width150'));

    ?>
    <?php echo $form->error($model, 'active'); ?>
    <br/>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'name',
        'type' => 'string',
    ));

    ?>

    <?php
    $this->widget('application.modules.lang.components.langFieldWidget', array(
        'model' => $model,
        'field' => 'description',
        'type' => 'text-editor',
    ));

    ?>

    <div class="clear"></div>

    <?php
    if ($model->dataModel) {
        require '_form_' . $model->dataModel . '.php';
    }

    ?>

    <br>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>
    </div>

    <?php $this->endWidget(); ?>

</div><!-- form -->