<?php
$this->breadcrumbs = array(
    tt('Manage subway stations', 'metroStations') => array('admin'),
    tt('Add multiple stations', 'metroStations'),
);

$this->menu = array(
    AdminLteHelper::getBackMenuLink(tt('Manage subway stations', 'metroStations'), array('admin')),
    AdminLteHelper::getAddMenuLink(tt('Add station', 'metroStations'), array('create')),
);
$this->adminTitle = tt('Add multiple stations', 'metroStations');

?>
<div class="flash-notice"><?php echo tt('Add multiple stations help', 'metroStations'); ?></div>
<div class="form">

    <?php
    $form = $this->beginWidget('CustomForm', array(
        'id' => $this->modelName . '-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('class' => 'well form-disable-button-after-submit'),
    ));

    ?>

    <p class="note"><?php echo Yii::t('common', 'Fields with <span class="required">*</span> are required.'); ?></p>
    <?php echo $form->errorSummary($model); ?>

    <?php if (issetModule('location')): ?>
        <div class="form-group">
            <?php echo CHtml::label(tc('Country'), 'countryId', array('required' => true)); ?>
            <?php
            echo CHtml::dropDownList(
                'MetroStations[country]', $model->country, Country::getCountriesArray(2, 0), array('class' => 'span3 form-control', 'id' => 'countryId',
                    'ajax' => array(
                        'type' => 'GET', //request type
                        'url' => $this->createUrl('/location/main/getRegions'), //url to call.
                        'data' => 'js:"country="+$("#countryId").val()+"&type=2"',
                        'success' => 'function(result){
								$("#regionId").html(result);
								$("#regionId").change();
							}'
                    )
                )
            );

            ?>
        </div>
        <div class="form-group">
            <?php echo CHtml::label(tc('Region'), 'regionId', array('required' => true)); ?>
            <?php
            echo CHtml::dropDownList(
                'MetroStations[region]', $model->region, Region::getRegionsArray($model->country, 2), array('class' => 'span3 form-control', 'id' => 'regionId',
                    'ajax' => array(
                        'type' => 'GET', //request type
                        'url' => $this->createUrl('/location/main/getCities'), //url to call.
                        'data' => 'js:"region="+$("#regionId").val()+"&type=0"',
                        'success' => 'function(result){
								$("#cityId").html(result);
							}'
                    )
                )
            );

            ?>
        </div>
        <div class="form-group">
            <?php echo CHtml::label(tc('City'), 'cityId', array('required' => true)); ?>
            <?php
            echo CHtml::dropDownList(
                'MetroStations[loc_city]', $model->loc_city, CArray::merge(array(0 => tc('select city')), City::getCitiesArray($model->region, 0)), array('class' => 'span3 form-control', 'id' => 'cityId')
            );

            ?>
        </div>
    <?php else: ?>
        <div class="form-group">
            <?php echo CHtml::label(tc('City'), 'cityId', array('required' => true)); ?>
            <?php
            echo CHtml::dropDownList(
                'MetroStations[city_id]', $model->city_id, ApartmentCity::getAllCity(), array('class' => 'span3 form-control', 'id' => 'cityId')
            );

            ?>
        </div>
    <?php endif; ?>
    <div class="clear"></div>
    <br/>

    <div class="form-group">
        <?php echo $form->labelEx($model, 'multy'); ?>
        <?php echo $form->textArea($model, 'multy', array('class' => 'width500 height100 form-control')); ?>
        <?php echo $form->error($model, 'multy'); ?>
    </div>
    <div class="clear"></div>
    <br/>

    <div class="form-group buttons">
        <?php
        echo AdminLteHelper::getSubmitButton($model->isNewRecord ? tc('Add') : tc('Save'));

        ?>
    </div>

    <?php $this->endWidget(); ?>
</div><!-- form -->